/*
 * Decompiled with CFR 0.152.
 */
package cronapi.odata.server;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import cronapi.QueryManager;
import cronapi.RestClient;
import cronapi.Var;
import cronapi.database.DataSource;
import cronapi.odata.server.ODataQuery;
import cronapi.odata.server.ODataQueryInterface;
import cronapi.util.JsonUtil;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.Parameter;
import javax.persistence.Query;
import javax.persistence.TemporalType;
import org.apache.olingo.odata2.api.uri.UriInfo;
import org.eclipse.persistence.internal.queries.ReportItem;
import org.eclipse.persistence.queries.ReportQuery;

public class BlocklyQuery
extends ODataQuery
implements Query,
ODataQueryInterface {
    private final Logger logger = Logger.getLogger(BlocklyQuery.class.getName());
    public static ThreadLocal<BlocklyQuery> CURRENT_BLOCK_QUERY = new ThreadLocal();
    private Var lastResult;

    public BlocklyQuery(JsonObject query, String method, String type, String queryStatement, UriInfo uriInfo) {
        super(query, method, type, queryStatement, uriInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List getResultList() {
        try {
            Object params;
            CURRENT_BLOCK_QUERY.set(this);
            Var result = null;
            if (this.lastResult != null) {
                result = this.lastResult;
            }
            if (result == null) {
                params = new Var[]{};
                if (!JsonUtil.isNull(this.query.get("queryParamsValues"))) {
                    JsonArray paramValues = this.query.getAsJsonArray("queryParamsValues");
                    params = new Var[paramValues.size()];
                    for (int x = 0; x < paramValues.size(); ++x) {
                        String strValue;
                        JsonObject prv = paramValues.get(x).getAsJsonObject();
                        if (JsonUtil.isNull(prv.get("fieldName"))) continue;
                        String name = prv.get("fieldName").getAsString();
                        params[x] = Var.VAR_NULL;
                        JsonElement fieldValue = prv.get("fieldValue");
                        Map<String, Var> customValues = this.getCustomValues();
                        params[x] = JsonUtil.isNullOrBlank(fieldValue) || customValues.containsKey(fieldValue.getAsString()) ? ((strValue = RestClient.getRestClient().getParameter(name)) != null ? Var.valueOf(strValue) : QueryManager.getParameterValue(this.query, name, customValues)) : (JsonUtil.isNull(fieldValue) ? Var.VAR_NULL : QueryManager.getParameterValue(this.query, name, customValues));
                    }
                }
                result = QueryManager.executeBlockly(this.query, this.method, params);
            }
            if (result.isNull().booleanValue()) {
                params = Collections.emptyList();
                return params;
            }
            if (!QueryManager.isNull(this.query.get("baseEntity"))) {
                try {
                    this.parameters.put("baseEntity", this.query.get("baseEntity").getAsString());
                    this.lastResult = result;
                    params = (List)result.getObjectAsRawList(LinkedList.class);
                    return params;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            if (result.getObject() instanceof DataSource) {
                List data = this.normalizeDatasource(result);
                this.lastResult = Var.valueOf(data);
                List list = data;
                return list;
            }
            this.lastResult = result;
            List list = result.getObjectAsList();
            return list;
        }
        finally {
            CURRENT_BLOCK_QUERY.remove();
        }
    }

    private List toList(List list) {
        LinkedList<Var> myList = new LinkedList<Var>();
        for (Object obj : list) {
            myList.add(Var.valueOf(obj));
        }
        return myList;
    }

    private List normalizeDatasource(Var result) {
        DataSource dataSource = (DataSource)result.getObject();
        List list = this.toList(dataSource.getPage().getContent());
        try {
            LinkedList newList;
            if (dataSource.getQueryParsed() instanceof ReportQuery) {
                newList = new LinkedList();
                ReportQuery reportQuery = (ReportQuery)dataSource.getQueryParsed();
                List items = reportQuery.getItems();
                for (Object o : list) {
                    int index = 0;
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    for (ReportItem item : items) {
                        Object[] objectArray = (Object[])((Var)o).getObject();
                        map.put(item.getName(), objectArray[index]);
                        ++index;
                    }
                    newList.add(map);
                }
            } else {
                return result.getObjectAsList();
            }
            list.clear();
            list.addAll(newList);
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
        }
        return list;
    }

    @Override
    public void setUriInfo(UriInfo uriInfo) {
        this.uriInfo = uriInfo;
    }

    @Override
    public Var getLastResult() {
        return this.lastResult;
    }

    @Override
    public Long count() {
        if (this.getLastResult().getObject() instanceof DataSource) {
            long total = ((DataSource)this.getLastResult().getObject()).count();
            return total;
        }
        return this.lastResult.size();
    }

    @Override
    public void setLastResult(Var value) {
        this.lastResult = value;
    }

    public Object getSingleResult() {
        return this.getResultList().get(0);
    }

    public int executeUpdate() {
        return 0;
    }

    public Query setMaxResults(int maxResult) {
        this.parameters.put("MaxResults", maxResult);
        return this;
    }

    public int getMaxResults() {
        return this.parameters.containsKey("MaxResults") ? (Integer)this.parameters.get("MaxResults") : -1;
    }

    public Query setFirstResult(int startPosition) {
        this.parameters.put("FirstResult", startPosition);
        return this;
    }

    public int getFirstResult() {
        return this.parameters.containsKey("FirstResult") ? (Integer)this.parameters.get("FirstResult") : -1;
    }

    public Query setHint(String hintName, Object value) {
        this.parameters.put("hintName", value);
        return this;
    }

    public Map<String, Object> getHints() {
        return null;
    }

    private void putParameter(int index, Object value) {
        this.parameters.put(String.valueOf(index), value);
    }

    public <T> Query setParameter(Parameter<T> param, T value) {
        this.putParameter(param.getPosition(), value);
        return this;
    }

    public Query setParameter(Parameter<Calendar> param, Calendar value, TemporalType temporalType) {
        this.putParameter(param.getPosition(), value);
        return this;
    }

    public Query setParameter(Parameter<Date> param, Date value, TemporalType temporalType) {
        this.putParameter(param.getPosition(), value);
        return this;
    }

    public Query setParameter(String name, Object value) {
        this.parameters.put(name, value);
        return this;
    }

    public Query setParameter(String name, Calendar value, TemporalType temporalType) {
        this.parameters.put(name, value);
        return this;
    }

    public Query setParameter(String name, Date value, TemporalType temporalType) {
        this.parameters.put(name, value);
        return this;
    }

    public Query setParameter(int position, Object value) {
        this.putParameter(position, value);
        return this;
    }

    public Query setParameter(int position, Calendar value, TemporalType temporalType) {
        this.putParameter(position, value);
        return this;
    }

    public Query setParameter(int position, Date value, TemporalType temporalType) {
        this.putParameter(position, value);
        return this;
    }

    public Set<Parameter<?>> getParameters() {
        return null;
    }

    public Parameter<?> getParameter(String name) {
        return null;
    }

    public <T> Parameter<T> getParameter(String name, Class<T> type) {
        return null;
    }

    public Parameter<?> getParameter(int position) {
        return null;
    }

    public <T> Parameter<T> getParameter(int position, Class<T> type) {
        return null;
    }

    public boolean isBound(Parameter<?> param) {
        return false;
    }

    public <T> T getParameterValue(Parameter<T> param) {
        return null;
    }

    public Object getParameterValue(String name) {
        return this.parameters.get(name);
    }

    public Object getParameterValue(int position) {
        return null;
    }

    public Query setFlushMode(FlushModeType flushMode) {
        return null;
    }

    public FlushModeType getFlushMode() {
        return null;
    }

    public Query setLockMode(LockModeType lockMode) {
        return null;
    }

    public LockModeType getLockMode() {
        return null;
    }

    public <T> T unwrap(Class<T> cls) {
        return null;
    }

    @Override
    public UriInfo getUriInfo() {
        return this.uriInfo;
    }
}

