/*
 * Decompiled with CFR 0.152.
 */
package cronapi.odata.server;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import cronapi.QueryManager;
import cronapi.RestClient;
import cronapi.Var;
import cronapi.odata.server.ODataQuery;
import cronapi.odata.server.ODataQueryInterface;
import cronapi.odata.server.SOAPUtil;
import cronapi.util.Functions;
import cronapi.util.JsonUtil;
import cronapi.util.Operations;
import java.lang.reflect.Field;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.Parameter;
import javax.persistence.Query;
import javax.persistence.TemporalType;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URIBuilder;
import org.apache.olingo.odata2.api.edm.EdmLiteralKind;
import org.apache.olingo.odata2.api.uri.UriInfo;
import org.apache.olingo.odata2.core.edm.AbstractSimpleType;
import org.apache.olingo.odata2.core.edm.provider.EdmSimplePropertyImplProv;
import org.apache.olingo.odata2.jpa.processor.core.ODataJPAConfig;
import org.apache.olingo.odata2.jpa.processor.core.model.JPAEdmMappingImpl;

public class WebServicesQuery
extends ODataQuery
implements Query,
ODataQueryInterface {
    public static ThreadLocal<WebServicesQuery> CURRENT_REST_QUERY = new ThreadLocal();
    private Var lastResult;
    private Long count;
    private boolean isOData;
    private boolean isSOAP;
    private final ObjectMapper mapper;

    public WebServicesQuery(JsonObject query, String method, String type, String queryStatement, UriInfo uriInfo) {
        super(query, method, type, queryStatement, uriInfo);
        this.isOData = query.get("endpoint").getAsJsonObject().get("url").getAsString().contains("/api/cronapi/odata/");
        this.isSOAP = query.get("endpoint").getAsJsonObject().get("url").getAsString().toLowerCase().contains("wsdl");
        this.mapper = new ObjectMapper();
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public static boolean isNull(JsonElement value) {
        return value == null || value.isJsonNull();
    }

    private Map<String, Var> getHeaders(Object entity) {
        LinkedHashMap<String, Var> headers = new LinkedHashMap<String, Var>();
        if (!WebServicesQuery.isNull(this.query.get("headers"))) {
            JsonObject paramValues = this.query.get("headers").getAsJsonObject();
            for (Map.Entry entry : paramValues.entrySet()) {
                headers.put((String)entry.getKey(), QueryManager.parseExpressionValue(null, this.query, entity, (JsonElement)entry.getValue(), this.getCustomValues()));
            }
        }
        if (this.isOData) {
            if (!headers.containsKey("X-AUTH-TOKEN") || ((Var)headers.get("X-AUTH-TOKEN")).isEmptyOrNull().booleanValue()) {
                headers.put("X-AUTH-TOKEN", Var.valueOf(RestClient.getRestClient().getToken()));
            }
            if (!headers.containsKey("Accept") || ((Var)headers.get("Accept")).isEmptyOrNull().booleanValue()) {
                headers.put("Accept", Var.valueOf("application/json"));
            }
            if (!headers.containsKey("Content-Type") || ((Var)headers.get("Content-Type")).isEmptyOrNull().booleanValue()) {
                headers.put("Content-Type", Var.valueOf("application/json"));
            }
        }
        return headers;
    }

    private String getURL(Object entity) {
        try {
            Map<String, Var> customValues = this.getCustomValues();
            Object url = this.query.get("endpoint").getAsJsonObject().get("url").getAsString().replaceAll("\\{(\\w+)\\}", ":$1");
            Var varEntity = Var.valueOf(entity);
            Object id = "";
            JsonElement params = this.query.get("endpoint").getAsJsonObject().get(this.method).getAsJsonObject().get("parameters");
            if (!this.isSOAP && entity != null) {
                for (Object name : this.uriInfo.getTargetEntitySet().getEntityType().getPropertyNames()) {
                    EdmSimplePropertyImplProv edmSimplePropertyImplProv = (EdmSimplePropertyImplProv)this.uriInfo.getTargetEntitySet().getEntityType().getProperty((String)name);
                    if (!edmSimplePropertyImplProv.getProperty().isOriginalId()) continue;
                    Var value = Var.valueOf(varEntity.get(edmSimplePropertyImplProv.getName()));
                    if (this.isOData) {
                        if (((String)id).length() > 0) {
                            id = (String)id + ",";
                        }
                        id = (String)id + edmSimplePropertyImplProv.getName() + "=";
                        if (value.isNumber() || value.isBoolean()) {
                            id = (String)id + value.getObjectAsString();
                            continue;
                        }
                        id = (String)id + "'" + value.getObjectAsString() + "'";
                        continue;
                    }
                    if (!((String)id).isEmpty()) {
                        id = (String)id + "/";
                    }
                    id = (String)id + value.getObjectAsString();
                }
                customValues.put("primaryKeys", Var.valueOf(id));
                customValues.put("primaryKey", Var.valueOf(id));
                if (!((String)id).isEmpty()) {
                    id = this.isOData ? "(" + (String)id + ")" : "/" + (String)id;
                }
                if (!JsonUtil.isNull(params) && !JsonUtil.isNull(params.getAsJsonObject().get("$url"))) {
                    Var urlPath = QueryManager.parseExpressionValue(null, this.query, entity, params.getAsJsonObject().get("$url"), customValues);
                    url = (String)url + urlPath.getObjectAsString();
                } else if (this.method.equals("PUT") || this.method.equals("DELETE")) {
                    url = (String)url + (String)id;
                }
            }
            List<String> tokens = Functions.parseTokens((String)url);
            tokens.sort(Comparator.reverseOrder());
            for (String string : tokens) {
                if (!string.startsWith(":")) continue;
                String name = string.substring(1);
                url = ((String)url).replaceFirst(":" + name, QueryManager.getParameterValue(this.query, name, entity, customValues).getObjectAsString());
            }
            if (!JsonUtil.isNull(params) && !this.isSOAP) {
                URIBuilder uri = new URIBuilder((String)url);
                for (Map.Entry entry : params.getAsJsonObject().entrySet()) {
                    Var value;
                    if (((String)entry.getKey()).equals("$datapath") || ((String)entry.getKey()).equals("$url") || (value = QueryManager.parseExpressionValue(null, this.query, entity, (JsonElement)entry.getValue(), customValues)).isEmptyOrNull().booleanValue()) continue;
                    String key = (String)entry.getKey();
                    if (key.startsWith("$") && key.endsWith("$")) {
                        key = key.substring(1, key.length() - 1);
                        Var keyValue = QueryManager.parseExpressionValue(this.query, entity, key, customValues);
                        key = keyValue.getObjectAsString();
                    }
                    if (!StringUtils.isNotBlank((CharSequence)key)) continue;
                    uri.addParameter(key, value.getObjectAsString());
                    if (!Operations.IS_DEBUG) continue;
                    System.out.println("[ WebServicesQuery: param : ".concat(key).concat(" : ").concat(value.getObjectAsString()).concat(" ]"));
                }
                url = uri.toString();
            }
            String queryString = RestClient.getRestClient().getQueryString();
            if (this.isOData && !this.isSOAP && StringUtils.isNotEmpty((CharSequence)queryString)) {
                URIBuilder uRIBuilder = new URIBuilder((String)url);
                URIBuilder uriQs = new URIBuilder("http://empty?" + queryString);
                for (NameValuePair entry : uriQs.getQueryParams()) {
                    uRIBuilder.addParameter(entry.getName(), entry.getValue());
                    if (!Operations.IS_DEBUG) continue;
                    System.out.println("[ WebServicesQuery: param : ".concat(entry.getName()).concat(" : ").concat(entry.getValue()).concat(" ]"));
                }
                url = uRIBuilder.toString();
            }
            if (Operations.IS_DEBUG) {
                System.out.println("[ WebServicesQuery: url : ".concat((String)url).concat(" ]"));
            }
            return url;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public void checkError(DocumentContext element) {
        try {
            Object message = element.read("$.error.message.value", new Predicate[0]);
            throw new RuntimeException(message.toString());
        }
        catch (PathNotFoundException e) {
            try {
                Object message = element.read("$.error.error", new Predicate[0]);
                throw new RuntimeException(message.toString());
            }
            catch (PathNotFoundException pathNotFoundException) {
                return;
            }
        }
    }

    private Var callSoap(Object ds) {
        SOAPUtil soap = new SOAPUtil();
        JsonElement path = this.query.get("endpoint").getAsJsonObject().get(this.method);
        if (!QueryManager.isNull(path) && !JsonUtil.isNull(path.getAsJsonObject().get("name"))) {
            String function = path.getAsJsonObject().get("name").getAsString();
            SOAPUtil.ServiceMetadata metadata = soap.getSOAPMetadata(this.getURL(ds), function);
            JsonObject parameters = path.getAsJsonObject().get("parameters").getAsJsonObject();
            if (metadata.functions.size() > 0) {
                Object[] params = new Object[metadata.functions.get((int)0).inputs.length];
                int i = 0;
                for (Field field : metadata.functions.get((int)0).inputs) {
                    for (Map.Entry entry : parameters.entrySet()) {
                        if (!field.getName().equals(entry.getKey())) continue;
                        Var value = QueryManager.parseExpressionValue(null, this.query, ds, (JsonElement)entry.getValue(), this.getCustomValues());
                        params[i] = value.getObject(field.getType());
                    }
                    ++i;
                }
                return Var.valueOf(soap.call(function, this.getHeaders(ds), params));
            }
        }
        return Var.VAR_NULL;
    }

    private JsonObject getQueryParameters(String method) {
        JsonElement parameters = this.query.get("endpoint").getAsJsonObject().get(method).getAsJsonObject().get("parameters");
        if (parameters == null) {
            return new JsonObject();
        }
        return parameters.getAsJsonObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List getResultList() {
        try {
            LinkedList<Var> linkedList;
            LinkedList<Var> list;
            DocumentContext context;
            CURRENT_REST_QUERY.set(this);
            Var result = null;
            if (this.lastResult != null) {
                result = this.lastResult;
            }
            Map<String, Var> custom = this.getCustomValues();
            if (result == null) {
                context = null;
                if (this.isSOAP) {
                    result = this.callSoap(null);
                } else {
                    void var5_10;
                    try {
                        Map<String, Var> headers = this.getHeaders(null);
                        String string = Operations.getContentFromURL(Var.valueOf(this.method.equals("FILTER") ? "GET" : this.method), Var.valueOf(headers.get("Content-Type")), Var.valueOf(this.getURL(null)), Var.VAR_NULL, Var.valueOf(headers), Var.VAR_NULL, Var.VAR_NULL).getObjectAsString();
                        if (JsonUtil.isJson(string)) {
                            context = JsonPath.parse((String)string);
                            this.checkError(context);
                        } else {
                            JsonObject object = new JsonObject();
                            object.addProperty("content", string);
                            context = JsonPath.parse((String)object.toString());
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    JsonObject parameters = this.getQueryParameters(this.method);
                    JsonElement jsonElement = parameters.get("$datapath");
                    if (this.isOData && JsonUtil.isNullOrBlank(jsonElement) && (this.method.equals("GET") || this.method.equals("FILTER"))) {
                        JsonElement jsonElement2 = new JsonParser().parse("\"\\\"$.d.results\\\"\"");
                    }
                    result = !JsonUtil.isNullOrBlank((JsonElement)var5_10) ? Var.valueOf(context.read(QueryManager.parseExpressionValue(null, this.query, null, (JsonElement)var5_10, custom).getObjectAsString(), new Predicate[0])) : Var.valueOf(context.read("$", new Predicate[0]));
                    JsonElement countPath = this.getQueryParameters("COUNT").get("$datapath");
                    if (this.isOData && JsonUtil.isNullOrBlank(countPath)) {
                        countPath = new JsonParser().parse("\"\\\"$.d.__count\\\"\"");
                    }
                    if (!JsonUtil.isNullOrBlank(countPath)) {
                        try {
                            this.count = Var.valueOf(context.read(QueryManager.parseExpressionValue(null, this.query, null, countPath, custom).getObjectAsString(), new Predicate[0])).getObjectAsLong();
                        }
                        catch (Exception e) {
                            this.count = result.size();
                        }
                    } else {
                        this.count = result.size();
                    }
                }
            }
            this.addFields(null, result, custom);
            if (result.isNull().booleanValue()) {
                context = Collections.emptyList();
                return context;
            }
            if (!QueryManager.isNull(this.query.get("baseEntity")) && this.lastResult == null) {
                try {
                    this.parameters.put("baseEntity", this.query.get("baseEntity").getAsString());
                    this.lastResult = result;
                    Class<?> classType = Class.forName(this.query.get("baseEntity").getAsString());
                    LinkedList<Object> items = new LinkedList<Object>();
                    Iterator iterator = result.getObjectAsList().iterator();
                    while (true) {
                        if (!iterator.hasNext()) {
                            LinkedList<Object> linkedList2 = items;
                            return linkedList2;
                        }
                        Object o = iterator.next();
                        if (o instanceof Map) {
                            this.convertMap((Map)o);
                        }
                        Object item = this.mapper.convertValue(o, classType);
                        items.add(item);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            this.lastResult = result;
            if (result.getObject() instanceof Map) {
                this.convertMap((Map)result.getObject());
                list = new LinkedList<Var>();
                list.add(result);
                if (this.count == null) {
                    this.count = 1L;
                }
                linkedList = list;
                return linkedList;
            }
            list = result.getObjectAsVarList(LinkedList.class);
            if (this.count == null) {
                this.count = list.size();
            }
            for (Object e : list) {
                if (e instanceof Map) {
                    this.convertMap((Map)e);
                    continue;
                }
                if (!(e instanceof Var) || !(((Var)e).getObject() instanceof Map)) continue;
                this.convertMap((Map)((Var)e).getObject());
            }
            linkedList = list;
            return linkedList;
        }
        finally {
            CURRENT_REST_QUERY.remove();
        }
    }

    private Map convertMap(Map map) {
        try {
            for (String name : this.uriInfo.getTargetEntitySet().getEntityType().getPropertyNames()) {
                Object value;
                EdmSimplePropertyImplProv property = (EdmSimplePropertyImplProv)this.uriInfo.getTargetEntitySet().getEntityType().getProperty(name);
                if (!map.containsKey(name) || !((value = map.get(name)) instanceof String)) continue;
                Object valueObj = ((AbstractSimpleType)property.getType()).valueOfString(value.toString(), EdmLiteralKind.JSON, property.getFacets(), ((JPAEdmMappingImpl)property.getMapping()).getOriginaType());
                map.put(name, valueObj);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    private void addFields(Object ds, Var result, Map<String, Var> custom) {
        JsonObject fields = this.query.get("defaultValuesProperties").getAsJsonObject();
        for (Map.Entry entry : fields.entrySet()) {
            String fieldPath;
            if (JsonUtil.isNull(((JsonElement)entry.getValue()).getAsJsonObject().get("path")) || !StringUtils.isNotBlank((CharSequence)(fieldPath = QueryManager.parseExpressionValue(null, this.query, ds, ((JsonElement)entry.getValue()).getAsJsonObject().get("path"), custom).getObjectAsString()))) continue;
            this.addField(result.getObject(), fieldPath, (String)entry.getKey());
        }
    }

    private void addField(Object object, String path, String field) {
        block4: {
            block3: {
                if (!(object instanceof List)) break block3;
                for (Object o : (List)object) {
                    this.addField(o, path, field);
                }
                break block4;
            }
            if (!(object instanceof Map)) break block4;
            try {
                DocumentContext context = JsonPath.parse((Object)object);
                Object value = context.read(path, new Predicate[0]);
                ((Map)object).put(field, value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean delete(Object entity) {
        try {
            Map<String, Var> headers = this.getHeaders(entity);
            if (this.isSOAP) {
                this.callSoap(entity);
            } else {
                DocumentContext context = JsonPath.parse((Object)Operations.getContentFromURL(Var.valueOf(RestClient.getRestClient().getMethod()), Var.valueOf(headers.get("Content-Type")), Var.valueOf(this.getURL(entity)), Var.VAR_NULL, Var.valueOf(headers), Var.VAR_NULL, Var.VAR_NULL));
                this.checkError(context);
            }
            return true;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Object save(Object entity) {
        try {
            EdmSimplePropertyImplProv property;
            Map<String, Var> headers = this.getHeaders(entity);
            JsonObject json = new JsonObject();
            Var varEntity = Var.valueOf(entity);
            JsonObject fields = this.query.get("defaultValuesProperties").getAsJsonObject();
            JsonObject calcFields = this.query.get("calcFields").getAsJsonObject();
            boolean hasPath = false;
            boolean hasCalc = false;
            Boolean hasObjectKey = false;
            for (Object name : fields.keySet()) {
                if (!((String)name).equals(ODataJPAConfig.COMPOSITE_KEY_NAME)) continue;
                hasObjectKey = true;
                break;
            }
            LinkedList<String> keySet = varEntity.keySet();
            for (String name : this.uriInfo.getTargetEntitySet().getEntityType().getPropertyNames()) {
                JsonElement calc;
                JsonElement value = fields.get(name);
                if (!JsonUtil.isNull(value) && !JsonUtil.isNull(value.getAsJsonObject().get("path"))) {
                    hasPath = true;
                    continue;
                }
                if (!JsonUtil.isNull((JsonElement)calcFields) && !JsonUtil.isNull(calc = calcFields.get(name))) {
                    hasCalc = true;
                    continue;
                }
                if (!hasObjectKey.booleanValue() && name.equals(ODataJPAConfig.COMPOSITE_KEY_NAME)) continue;
                if (this.isOData) {
                    if (!keySet.contains(name) && !keySet.contains(name.toLowerCase())) continue;
                    JsonElement jsonValue = Var.valueOf(varEntity.get(name)).getObjectAsJsonElement();
                    json.add(name, jsonValue);
                    property = (EdmSimplePropertyImplProv)this.uriInfo.getTargetEntitySet().getEntityType().getProperty(name);
                    if (property == null || !property.getFacets().isAutoGenerated() || !JsonUtil.isNull(jsonValue)) continue;
                    json.remove(name);
                    continue;
                }
                json.add(name, Var.valueOf(varEntity.get(name)).getObjectAsJsonElement());
            }
            Var result = null;
            if (this.isSOAP) {
                result = this.callSoap(entity);
            } else {
                result = Operations.getContentFromURL(Var.valueOf(this.method), Var.valueOf(headers.get("Content-Type")), Var.valueOf(this.getURL(entity)), Var.VAR_NULL, Var.valueOf(headers), Var.VAR_NULL, Var.valueOf(json.toString()));
                DocumentContext context = JsonPath.parse((String)result.getObjectAsString());
                this.checkError(context);
                JsonElement path = this.getQueryParameters(this.method).get("$datapath");
                if (this.isOData && JsonUtil.isNullOrBlank(path) && (this.method.equals("POST") || this.method.equals("PUT"))) {
                    path = new JsonParser().parse("\"\\\"$.d\\\"\"");
                }
                result = !JsonUtil.isNullOrBlank(path) ? Var.valueOf(context.read(QueryManager.parseExpressionValue(null, this.query, entity, path, this.getCustomValues()).getObjectAsString(), new Predicate[0])) : Var.valueOf(context.read("$", new Predicate[0]));
            }
            boolean hasEntity = false;
            for (String name : this.uriInfo.getTargetEntitySet().getEntityType().getPropertyNames()) {
                property = (EdmSimplePropertyImplProv)this.uriInfo.getTargetEntitySet().getEntityType().getProperty(name);
                if (!property.getProperty().isOriginalId() || Var.valueOf(result.get(property.getName())).isNull().booleanValue()) continue;
                hasEntity = true;
                break;
            }
            if (!hasEntity || hasPath || hasCalc) {
                result = Var.valueOf(entity);
            }
            if (result.getObject() instanceof Map) {
                this.convertMap((Map)result.getObject());
            }
            if (!QueryManager.isNull(this.query.get("baseEntity"))) {
                try {
                    this.parameters.put("baseEntity", this.query.get("baseEntity").getAsString());
                    Class<?> classType = Class.forName(this.query.get("baseEntity").getAsString());
                    Object item = this.mapper.convertValue((Object)result, classType);
                    return item;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            if (result.isNull().booleanValue()) {
                return Var.valueOf(entity);
            }
            return Var.valueOf(result);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setUriInfo(UriInfo uriInfo) {
        this.uriInfo = uriInfo;
    }

    @Override
    public Var getLastResult() {
        return this.lastResult;
    }

    @Override
    public Long count() {
        return this.count;
    }

    @Override
    public void setLastResult(Var value) {
        this.lastResult = value;
    }

    public Object getSingleResult() {
        return this.getResultList().get(0);
    }

    public int executeUpdate() {
        return 0;
    }

    public Query setMaxResults(int maxResult) {
        this.parameters.put("MaxResults", maxResult);
        return this;
    }

    public int getMaxResults() {
        return this.parameters.containsKey("MaxResults") ? (Integer)this.parameters.get("MaxResults") : -1;
    }

    public Query setFirstResult(int startPosition) {
        this.parameters.put("FirstResult", startPosition);
        return this;
    }

    public int getFirstResult() {
        return this.parameters.containsKey("FirstResult") ? (Integer)this.parameters.get("FirstResult") : -1;
    }

    public Query setHint(String hintName, Object value) {
        this.parameters.put("hintName", value);
        return this;
    }

    public Map<String, Object> getHints() {
        return null;
    }

    private void putParameter(int index, Object value) {
        this.parameters.put(String.valueOf(index), value);
    }

    public <T> Query setParameter(Parameter<T> param, T value) {
        this.putParameter(param.getPosition(), value);
        return this;
    }

    public Query setParameter(Parameter<Calendar> param, Calendar value, TemporalType temporalType) {
        this.putParameter(param.getPosition(), value);
        return this;
    }

    public Query setParameter(Parameter<Date> param, Date value, TemporalType temporalType) {
        this.putParameter(param.getPosition(), value);
        return this;
    }

    public Query setParameter(String name, Object value) {
        this.parameters.put(name, value);
        return this;
    }

    public Query setParameter(String name, Calendar value, TemporalType temporalType) {
        this.parameters.put(name, value);
        return this;
    }

    public Query setParameter(String name, Date value, TemporalType temporalType) {
        this.parameters.put(name, value);
        return this;
    }

    public Query setParameter(int position, Object value) {
        this.putParameter(position, value);
        return this;
    }

    public Query setParameter(int position, Calendar value, TemporalType temporalType) {
        this.putParameter(position, value);
        return this;
    }

    public Query setParameter(int position, Date value, TemporalType temporalType) {
        this.putParameter(position, value);
        return this;
    }

    public Set<Parameter<?>> getParameters() {
        return null;
    }

    public Parameter<?> getParameter(String name) {
        return null;
    }

    public <T> Parameter<T> getParameter(String name, Class<T> type) {
        return null;
    }

    public Parameter<?> getParameter(int position) {
        return null;
    }

    public <T> Parameter<T> getParameter(int position, Class<T> type) {
        return null;
    }

    public boolean isBound(Parameter<?> param) {
        return false;
    }

    public <T> T getParameterValue(Parameter<T> param) {
        return null;
    }

    public Object getParameterValue(String name) {
        return this.parameters.get(name);
    }

    public Object getParameterValue(int position) {
        return null;
    }

    public Query setFlushMode(FlushModeType flushMode) {
        return null;
    }

    public FlushModeType getFlushMode() {
        return null;
    }

    public Query setLockMode(LockModeType lockMode) {
        return null;
    }

    public LockModeType getLockMode() {
        return null;
    }

    public <T> T unwrap(Class<T> cls) {
        return null;
    }

    @Override
    public UriInfo getUriInfo() {
        return this.uriInfo;
    }
}

