/*
 * Decompiled with CFR 0.152.
 */
package io.cronapp.reverse;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import cronapi.util.ReflectionUtils;
import io.cronapp.reverse.utils.ReverseEngineeringData;
import io.cronapp.reverse.utils.ReverseEngineeringDataContext;
import io.cronapp.reverse.utils.ReverseEngineeringUtils;
import jakarta.persistence.TemporalType;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.conf.JDBCConfigurationImpl;
import org.apache.openjpa.jdbc.identifier.DBIdentifier;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.FieldMapping;
import org.apache.openjpa.jdbc.meta.PropertiesReverseCustomizer;
import org.apache.openjpa.jdbc.meta.ReverseCustomizer;
import org.apache.openjpa.jdbc.meta.ReverseMappingTool;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.Constraint;
import org.apache.openjpa.jdbc.schema.ForeignKey;
import org.apache.openjpa.jdbc.schema.SchemaGenerator;
import org.apache.openjpa.jdbc.schema.SchemaGroup;
import org.apache.openjpa.jdbc.schema.Sequence;
import org.apache.openjpa.jdbc.schema.Table;
import org.apache.openjpa.lib.util.StringUtil;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.MetaDataException;

public class DiagramBuilder
implements Serializable {
    private static final Pattern ORACLE_SEQUENCE_PATTERN = Pattern.compile("(\\\"?\\w+\\\"?\\.\\\"?.+?\\\"?)\\.\\\"?NEXTVAL\\\"?", 2);
    private ReverseEngineeringDataContext dataSource;
    private boolean usePhysicalNames;
    private boolean extractRelations;
    private String keyGenerationStrategy = "auto";
    private String sequencePattern;
    private Map<String, List<String>> tablesWithFields;
    private List<String> views;
    private static final Map<String, String> _javaKeywords = new HashMap<String, String>();

    public DiagramBuilder(ReverseEngineeringData data) {
        this.dataSource = data.getContext();
        this.usePhysicalNames = data.isUsePhysicalNames();
        this.extractRelations = data.isExtractRelations();
        this.keyGenerationStrategy = data.getKeyGenerationStrategy();
        this.sequencePattern = data.getSequencePattern();
        this.tablesWithFields = data.getTablesWithFields();
        this.views = data.getViews();
    }

    private SchemaGroup getSchemaGroup(JDBCConfiguration configuration, DBIdentifier[] identifiers) throws SQLException {
        SchemaGenerator generator = new SchemaGenerator(configuration);
        generator.setOpenJPATables(false);
        generator.generateSchemas(identifiers);
        generator.setForeignKeys(this.extractRelations);
        return generator.getSchemaGroup();
    }

    private void ensurePrimaryKeys(SchemaGroup schemaGroup) {
        Arrays.stream(schemaGroup.getSchemas()).flatMap(schema -> Arrays.stream(schema.getTables())).forEach(table -> {
            if (table.getPrimaryKey() != null) {
                return;
            }
            if (table.getColumns().length == 0) {
                return;
            }
            table.addPrimaryKey().addColumn(table.getColumns()[0]);
        });
    }

    private void removeFks(SchemaGroup schemaGroup) {
        Arrays.stream(schemaGroup.getSchemas()).flatMap(schema -> Arrays.stream(schema.getTables())).forEach(table -> {
            ArrayList<ForeignKey> fks = new ArrayList<ForeignKey>();
            for (int i = 0; i < table.getForeignKeys().length; ++i) {
                ForeignKey foreignKey = table.getForeignKeys()[i];
                fks.add(foreignKey);
            }
            fks.forEach(f -> table.removeForeignKey(f));
        });
    }

    private static boolean hasPrefix(String name) {
        return name.length() > 4 && name.charAt(3) == '_' && StringUtils.isAllUpperCase((CharSequence)name.substring(0, 3));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonObject getCellsFromResource() throws Exception {
        Path tempDir = Files.createTempDirectory("tmp-cronos-reverse", new FileAttribute[0]);
        Files.createDirectories(tempDir, new FileAttribute[0]);
        try {
            JsonObject result;
            DBIdentifier[] identifiers = (DBIdentifier[])this.tablesWithFields.keySet().stream().map(DBIdentifier::newTable).toArray(DBIdentifier[]::new);
            Properties props = new Properties();
            props.setProperty("openjpa.ConnectionDriverName", this.dataSource.getDriverClassName());
            props.setProperty("openjpa.ConnectionURL", this.dataSource.getUrl());
            props.setProperty("openjpa.ConnectionUserName", this.dataSource.getUsername());
            props.setProperty("openjpa.ConnectionPassword", this.dataSource.getPassword());
            props.setProperty("openjpa.jdbc.SynchronizeMappings", "buildSchema");
            props.setProperty("openjpa.RuntimeUnenhancedClasses", "supported");
            JDBCConfigurationImpl configuration = new JDBCConfigurationImpl();
            configuration.setMetaDataFactory("io.cronapp.reverse.JDBCMetaDataFactory");
            configuration.fromProperties((Map)props);
            configuration.instantiateAll();
            configuration.getDBDictionaryInstance().schemaCase = "preserve";
            SchemaGroup schema = this.getSchemaGroup((JDBCConfiguration)configuration, identifiers);
            this.ensurePrimaryKeys(schema);
            this.removeDuplicateForeignKeys(schema);
            if (!this.extractRelations) {
                this.removeFks(schema);
            }
            try {
                result = this.getCellsFromMappingTool(true, tempDir, schema, this.tablesWithFields, this.views, configuration);
            }
            catch (Exception e) {
                if (e instanceof MetaDataException) {
                    result = this.getCellsFromMappingTool(false, tempDir, schema, this.tablesWithFields, this.views, configuration);
                }
                throw new RuntimeException(e);
            }
            JsonObject jsonObject = result;
            return jsonObject;
        }
        finally {
            FileUtils.forceDelete((File)tempDir.toFile());
        }
    }

    private JsonObject getCellsFromMappingTool(boolean withInverseRelation, Path tempDir, SchemaGroup schema, Map<String, List<String>> tablesWithFields, List<String> views, JDBCConfigurationImpl configuration) throws Exception {
        ReverseMappingTool mappingTool = new ReverseMappingTool((JDBCConfiguration)configuration){

            public FieldMapping newFieldMapping(String name, Class type, Column col, ForeignKey fk, ClassMapping dec) {
                ClassMapping rel;
                if (fk != null && DiagramBuilder.this.usePhysicalNames && (rel = this.getClassMapping(fk.getPrimaryKeyTable())) != dec) {
                    String orgName = this.getFieldName(rel.getDescribedType().getName(), dec);
                    Method m = ReflectionUtils.getMethod(ReverseMappingTool.class, "getUniqueName");
                    try {
                        m.setAccessible(true);
                        name = orgName = (String)m.invoke((Object)this, orgName, rel);
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
                FieldMapping field = super.newFieldMapping(name, type, col, fk, dec);
                return field;
            }

            public String getFieldName(String name, ClassMapping dec) {
                String pkName;
                if (DiagramBuilder.this.usePhysicalNames) {
                    String keyword = _javaKeywords.get(name);
                    if (StringUtils.isNotBlank((CharSequence)keyword)) {
                        return keyword;
                    }
                    return DiagramBuilder.replaceInvalidCharacters(name);
                }
                if (DiagramBuilder.hasPrefix(name) && dec.getTable().getPrimaryKey() != null && dec.getTable().getPrimaryKey().getColumns() != null && dec.getTable().getPrimaryKey().getColumns().length > 0 && DiagramBuilder.hasPrefix(pkName = dec.getTable().getPrimaryKey().getColumns()[0].getIdentifier().getName()) && name.substring(0, 3).equals(pkName.substring(0, 3))) {
                    name = name.substring(4);
                }
                String defaultName = super.getFieldName(name, dec);
                return defaultName;
            }
        };
        mappingTool.setSchemaGroup(schema);
        mappingTool.setGenerateAnnotations(true);
        mappingTool.setUseGenericCollections(true);
        mappingTool.setDirectory(tempDir.toFile());
        mappingTool.setPrimaryKeyOnJoin(false);
        mappingTool.setAccessType("field");
        mappingTool.setNullableAsObject(true);
        mappingTool.setUseSchemaElement(true);
        mappingTool.setInverseRelations(withInverseRelation);
        PropertiesReverseCustomizer custom = new PropertiesReverseCustomizer(){

            public String getClassName(Table table, String defaultName) {
                String tableName = ReverseEngineeringUtils.unquote(table.getIdentifier().getName());
                if (DiagramBuilder.this.usePhysicalNames) {
                    String keyword = _javaKeywords.get(tableName);
                    if (StringUtils.isNotBlank((CharSequence)keyword)) {
                        return keyword;
                    }
                    return DiagramBuilder.replaceInvalidCharacters(tableName);
                }
                if (DiagramBuilder.hasPrefix(tableName)) {
                    defaultName = defaultName.substring(3);
                }
                return super.getClassName(table, defaultName);
            }
        };
        custom.setTool(mappingTool);
        Properties customProperties = new Properties();
        customProperties.put("Process.rename", "ProcessClass");
        custom.setConfiguration(customProperties);
        mappingTool.setCustomizer((ReverseCustomizer)custom);
        Properties properties = new Properties();
        HashMap<String, String> typeMap = new HashMap<String, String>();
        typeMap.put("uniqueidentifier", "java.lang.String");
        typeMap.put("uuid", "java.util.UUID");
        properties.putAll((Map<?, ?>)typeMap);
        mappingTool.setTypeMap(properties);
        mappingTool.run();
        mappingTool.buildAnnotations();
        JsonObject result = this.toJoint(schema, mappingTool, tablesWithFields, views);
        return result;
    }

    private static String replaceInvalidCharacters(String str) {
        int end;
        int start;
        if (StringUtil.isEmpty((String)str)) {
            return str;
        }
        StringBuilder buf = new StringBuilder(str);
        for (int i = 0; i < buf.length(); ++i) {
            char c = buf.charAt(i);
            if (c != '$' && Character.isJavaIdentifierPart(str.charAt(i))) continue;
            buf.setCharAt(i, '_');
        }
        for (start = 0; start < buf.length() && buf.charAt(start) == '_'; ++start) {
        }
        for (end = buf.length() - 1; end >= 0 && buf.charAt(end) == '_'; --end) {
        }
        if (start > end) {
            return "x";
        }
        return buf.substring(start, end + 1);
    }

    private void removeDuplicateForeignKeys(SchemaGroup schema) {
        ArrayList duplicateFk = new ArrayList();
        Arrays.stream(schema.getSchemas()).flatMap(s -> Arrays.stream(s.getTables())).forEach(table -> {
            for (int i = 0; i < table.getForeignKeys().length; ++i) {
                ForeignKey foreignKey = table.getForeignKeys()[i];
                for (int x = i + 1; x < table.getForeignKeys().length; ++x) {
                    boolean isSame = true;
                    ForeignKey foreignKeyToCheck = table.getForeignKeys()[x];
                    if (foreignKey.getColumns().length == foreignKeyToCheck.getColumns().length) {
                        for (int idxCol = 0; idxCol < foreignKey.getColumns().length; ++idxCol) {
                            if (foreignKey.getColumns()[idxCol].getName().equals(foreignKeyToCheck.getColumns()[idxCol].getName())) continue;
                            isSame = false;
                        }
                    } else {
                        isSame = false;
                    }
                    if (!isSame) continue;
                    duplicateFk.add(foreignKey);
                }
            }
            duplicateFk.forEach(f -> table.removeForeignKey(f));
            duplicateFk.clear();
        });
    }

    private JsonObject toJoint(SchemaGroup schemaGroup, ReverseMappingTool mappingTool, Map<String, List<String>> tablesWithFields, List<String> views) {
        JsonArray jsonCells = new JsonArray();
        JsonObject rectCell = this.createRectCell(this.dataSource);
        jsonCells.add((JsonElement)rectCell);
        List sequences = Arrays.stream(schemaGroup.getSchemas()).flatMap(schema -> Arrays.stream(schema.getSequences())).collect(Collectors.toList());
        Arrays.stream(schemaGroup.getSchemas()).flatMap(schema -> Arrays.stream(schema.getTables())).map(arg_0 -> ((ReverseMappingTool)mappingTool).getClassMapping(arg_0)).filter(Objects::nonNull).map(mapping -> this.toJoint((ClassMapping)mapping, mappingTool, sequences, tablesWithFields, views)).forEach(arg_0 -> ((JsonArray)jsonCells).add(arg_0));
        Arrays.stream(schemaGroup.getSchemas()).flatMap(schema -> Arrays.stream(schema.getTables())).map(arg_0 -> ((ReverseMappingTool)mappingTool).getClassMapping(arg_0)).filter(Objects::nonNull).flatMap(mapping -> Arrays.stream(mapping.getFields())).filter(fieldMetaData -> FieldMapping.class.isAssignableFrom(fieldMetaData.getClass())).map(fieldMetaData -> (FieldMapping)fieldMetaData).filter(fieldMapping -> fieldMapping.getForeignKey() != null).filter(fieldMapping -> fieldMapping.getDeclaringMapping().getTable() != fieldMapping.getForeignKey().getPrimaryKeyTable()).map(fieldMetaData -> this.toJointRelationship((FieldMapping)fieldMetaData, jsonCells)).filter(Objects::nonNull).forEach(arg_0 -> ((JsonArray)jsonCells).add(arg_0));
        JsonObject result = new JsonObject();
        result.add("cells", (JsonElement)jsonCells);
        return result;
    }

    private FieldMapping[] getFieldMappings(ClassMapping mapping) {
        return (FieldMapping[])Arrays.stream(mapping.getDeclaredFields()).filter(fieldMetaData -> FieldMapping.class.isAssignableFrom(fieldMetaData.getClass())).map(fieldMetaData -> (FieldMapping)fieldMetaData).filter(fieldMapping -> fieldMapping.getColumns().length != 0).sorted((left, right) -> {
            int primaryKeyComparison = Boolean.compare(right.getColumns()[0].isPrimaryKey(), left.getColumns()[0].isPrimaryKey());
            if (primaryKeyComparison != 0) {
                return primaryKeyComparison;
            }
            return left.compareTo(right);
        }).toArray(FieldMapping[]::new);
    }

    private TemporalType getTemporal(FieldMapping field) {
        if (field.getDeclaredTypeCode() != 14 && field.getDeclaredTypeCode() != 28) {
            return null;
        }
        switch (field.getColumns()[0].getType()) {
            case 91: {
                return TemporalType.DATE;
            }
            case 92: {
                return TemporalType.TIME;
            }
            case 93: {
                return TemporalType.TIMESTAMP;
            }
        }
        return null;
    }

    private boolean isPartialPrimaryKey(FieldMapping mapping) {
        AtomicBoolean result = new AtomicBoolean(false);
        Arrays.stream(mapping.getColumns()).forEach(column -> {
            Set constraints = column.getConstraints();
            if (constraints != null) {
                constraints.stream().filter(c -> c instanceof ForeignKey).forEach(c -> {
                    boolean hasPrimary = Arrays.stream(((ForeignKey)c).getColumns()).anyMatch(Column::isPrimaryKey);
                    boolean allPrimary = Arrays.stream(((ForeignKey)c).getColumns()).allMatch(Column::isPrimaryKey);
                    if (hasPrimary && !allPrimary) {
                        result.set(true);
                    }
                });
            }
        });
        return result.get();
    }

    private JsonObject toJoint(ClassMapping mapping, ReverseMappingTool mappingTool, List<Sequence> schemaSequences, Map<String, List<String>> tableAndFields, List<String> views) {
        Table table = mapping.getTable();
        String tableName = ReverseEngineeringUtils.unquote(table.getIdentifier().getName());
        String className = mapping.getResourceName();
        String schemaName = ReverseEngineeringUtils.unquote(table.getSchemaIdentifier().getName());
        FieldMapping[] fields = this.getFieldMappings(mapping);
        JsonObject jsonClassBuilder = new JsonObject();
        jsonClassBuilder.addProperty("name", className);
        jsonClassBuilder.addProperty("id", UUID.randomUUID().toString());
        jsonClassBuilder.addProperty("type", "uml.Class");
        jsonClassBuilder.addProperty("runtimeClass", "cronos.widgets.joint.uml.Class");
        jsonClassBuilder.addProperty("tableName", tableName);
        if (StringUtils.isNotEmpty((CharSequence)schemaName)) {
            jsonClassBuilder.addProperty("tableScheme", schemaName);
        }
        jsonClassBuilder.add("attrs", (JsonElement)this.getJointAttrs(className, mapping));
        JsonObject position = new JsonObject();
        position.addProperty("x", (Number)0);
        position.addProperty("y", (Number)0);
        jsonClassBuilder.add("position", (JsonElement)position);
        Size size = this.getSize(mapping);
        JsonObject sizeObj = new JsonObject();
        sizeObj.addProperty("width", (Number)size.width);
        sizeObj.addProperty("height", (Number)size.height);
        jsonClassBuilder.add("size", (JsonElement)sizeObj);
        jsonClassBuilder.addProperty("z", (Number)2);
        JsonArray jsonFields = new JsonArray();
        JsonArray jsonLabels = new JsonArray();
        JsonArray jsonDbFields = new JsonArray();
        JsonArray nullables = new JsonArray();
        JsonArray requireds = new JsonArray();
        JsonArray primaryKeys = new JsonArray();
        JsonArray uniqueKeys = new JsonArray();
        JsonArray keyTypes = new JsonArray();
        JsonArray sequences = new JsonArray();
        JsonArray foreignKeysName = new JsonArray();
        JsonArray joins = new JsonArray();
        JsonArray updatable = new JsonArray();
        JsonArray insertable = new JsonArray();
        JsonArray dbLengths = new JsonArray();
        JsonArray dbPrecisions = new JsonArray();
        JsonArray dbScales = new JsonArray();
        int pkSize = table.getPrimaryKey().getColumns().length;
        String jdbcProtocol = DiagramBuilder.getProtocol(this.dataSource.getUrl());
        List<String> fieldsName = this.selectFields(tableName, tableAndFields);
        for (FieldMapping field : fields) {
            Matcher matcher;
            String dbFieldName;
            String fieldTypeName;
            String tableFieldName;
            Class fieldType;
            String dbField;
            Column[] fieldColumns = field.getColumns();
            boolean isForeignKey = !this.extractRelations ? false : Arrays.stream(fieldColumns).allMatch(Column::isForeignKey);
            boolean isPrimaryKey = Arrays.stream(fieldColumns).allMatch(Column::isPrimaryKey);
            boolean readOnly = false;
            if (isPrimaryKey && isForeignKey && field.getInverseMappings().length == 0) {
                if (fieldColumns.length != 1 || !this.isPartialPrimaryKey(field)) continue;
                readOnly = true;
            }
            if ((dbField = field.getColumns()[0].getIdentifier().getName()) != null) {
                dbField = dbField.toLowerCase();
            }
            if (dbField == null || fieldsName != null && !fieldsName.isEmpty() && !fieldsName.contains(dbField.toLowerCase()) || field.isNonDefaultMappingUsingJoinTableStrategy() || (fieldType = field.getType()).isAssignableFrom(Set.class) || !(tableFieldName = field.getColumns()[0].getTableIdentifier().getName()).equalsIgnoreCase(tableName)) continue;
            String string = !fieldType.isArray() ? ReverseEngineeringUtils.getWrapperType(fieldType.getName()) : (fieldTypeName = "[B".equals(fieldType.getName()) ? "byte[]" : ReverseEngineeringUtils.getWrapperType(fieldType.getComponentType().getName()) + "[]");
            if (fieldTypeName.equals("byte[]")) {
                fieldTypeName = field.getName().toLowerCase().matches("(.*?image.*?|.*?foto.*?|.*?pic.*?|.*?photo.*?|.*?img.*?|.*?logo.*?|.*?banner.*?|.*?icon.*?|.*?avatar.*?|.*?figure.*?|.*?ilustration.*?|.*?figura.*?|.*?ilustracao.*?)") ? "Image Upload (to Database)" : "File Upload (to Database)";
            }
            Column[] columns = field.getColumns();
            Column column = columns[0];
            String dbFieldType = column.getTypeIdentifier().getName();
            String dbFieldDefault = column.getDefaultString();
            String dbFieldSequence = "";
            String keyType = "None";
            TemporalType temporal = this.getTemporal(field);
            if (temporal != null) {
                switch (temporal) {
                    case TIMESTAMP: {
                        fieldTypeName = "java.sql.Date";
                        break;
                    }
                    case DATE: {
                        fieldTypeName = "java.util.Date";
                        break;
                    }
                    case TIME: {
                        fieldTypeName = "java.sql.Time";
                    }
                }
            }
            if (StringUtils.contains((CharSequence)jdbcProtocol, (CharSequence)"sqlserver")) {
                if (StringUtils.equalsIgnoreCase((CharSequence)dbFieldType, (CharSequence)"timestamp")) {
                    fieldTypeName = "rowversion";
                } else if (StringUtils.equalsIgnoreCase((CharSequence)dbFieldType, (CharSequence)"xml")) {
                    fieldTypeName = "xml";
                }
            }
            if (this.usePhysicalNames) {
                jsonFields.add(String.format("%s:%s", field.getName(), fieldTypeName));
            } else {
                jsonFields.add(ReverseEngineeringUtils.normalizeToJSONProperty(String.format("%s:%s", field.getName(), fieldTypeName)));
            }
            if (isForeignKey) {
                String foreignKeyName = "";
                Object join = "";
                Optional<Column> firstColumn = Arrays.stream(fieldColumns).findFirst();
                if (firstColumn.isPresent()) {
                    foreignKeyName = firstColumn.get().getConstraints().stream().filter(c -> c instanceof ForeignKey).findFirst().get().getName();
                    for (Column c2 : fieldColumns) {
                        for (Constraint fk : c2.getConstraints()) {
                            if (!(fk instanceof ForeignKey) || !fk.getName().equals(foreignKeyName)) continue;
                            if (!((String)join).isEmpty()) {
                                join = (String)join + ";";
                            }
                            join = (String)join + c2.getName() + ":" + String.valueOf(((ForeignKey)fk).getPrimaryKeyColumn(c2));
                        }
                    }
                }
                foreignKeysName.add(foreignKeyName);
                joins.add((String)join);
            } else {
                foreignKeysName.add("");
                joins.add("");
            }
            String labelName = StringUtils.capitalize((String)ReverseEngineeringUtils.splitCamelCase(field.getName())).trim();
            jsonLabels.add(labelName);
            ForeignKey foreignKey = field.getForeignKey();
            if (foreignKey == null) {
                dbFieldName = Arrays.stream(columns).map(c -> c.getIdentifier().getName()).collect(Collectors.joining(";"));
            } else {
                ClassMapping primaryKeyMapping = mappingTool.getClassMapping(foreignKey.getPrimaryKeyTable());
                List primaryKeyFields = Arrays.stream(this.getFieldMappings(primaryKeyMapping)).map(FieldMetaData::getName).collect(Collectors.toList());
                dbFieldName = Arrays.stream(columns).sorted((left, right) -> {
                    String leftPrimaryKeyColumnName = foreignKey.getPrimaryKeyColumn(left).getIdentifier().getName();
                    String rightPrimaryKeyColumnName = foreignKey.getPrimaryKeyColumn(right).getIdentifier().getName();
                    return Integer.compare(primaryKeyFields.indexOf(leftPrimaryKeyColumnName), primaryKeyFields.indexOf(rightPrimaryKeyColumnName));
                }).map(c -> c.getIdentifier().getName()).collect(Collectors.joining(";"));
            }
            if (column.isNotNull()) {
                nullables.add(field.getName());
            }
            if (column.isUniqueConstraint()) {
                uniqueKeys.add(field.getName());
            }
            int columnSize = column.getSize();
            if (this.hasLength(field.getTypeCode()) && columnSize > 0) {
                dbLengths.add((Number)columnSize);
            } else {
                dbLengths.add("");
            }
            int columnDecimalDigits = column.getDecimalDigits();
            if (columnDecimalDigits > 0) {
                dbPrecisions.add((Number)columnDecimalDigits);
            } else {
                dbPrecisions.add("");
            }
            if (column.getScale() > 0) {
                dbScales.add((Number)column.getScale());
            } else {
                dbScales.add("");
            }
            if (readOnly) {
                updatable.add(Boolean.valueOf(false));
                insertable.add(Boolean.valueOf(false));
            } else {
                updatable.add(Boolean.valueOf(true));
                insertable.add(Boolean.valueOf(true));
            }
            if (isPrimaryKey) {
                primaryKeys.add(field.getName());
                if (!column.isForeignKey() && StringUtils.equals((CharSequence)this.keyGenerationStrategy, (CharSequence)"sequence") && StringUtils.isNotEmpty((CharSequence)this.sequencePattern)) {
                    String sequenceName = this.sequencePattern.toUpperCase().replace("${TABLENAME}", tableName).replace("${FIELDNAME}", dbField);
                    Sequence schemaSequence = schemaSequences.stream().filter(s -> s.getIdentifier().getName().toUpperCase().equals(sequenceName)).findFirst().orElse(null);
                    if (schemaSequence != null) {
                        keyType = "Identity";
                        dbFieldSequence = schemaSequence.getFullIdentifier().getName();
                    }
                }
            }
            if (fieldType.isAssignableFrom(String.class) && field.getForeignKey() == null && pkSize == 1 && (column.getSize() == 38 || this.keyGenerationStrategy.equals("force"))) {
                keyType = "UUID";
            }
            if (fieldType.isAssignableFrom(UUID.class) && field.getForeignKey() == null && pkSize == 1) {
                keyType = "UUID";
            }
            if (StringUtils.contains((CharSequence)jdbcProtocol, (CharSequence)"sqlserver")) {
                if (StringUtils.contains((CharSequence)dbFieldType, (CharSequence)"identity")) {
                    keyType = "Identity";
                }
            } else if (StringUtils.contains((CharSequence)jdbcProtocol, (CharSequence)"oracle") && StringUtils.isNotEmpty((CharSequence)dbFieldDefault) && (matcher = ORACLE_SEQUENCE_PATTERN.matcher(dbFieldDefault)).find()) {
                keyType = "Identity";
                dbFieldSequence = matcher.group(1);
            }
            keyTypes.add(keyType);
            sequences.add(dbFieldSequence);
            jsonDbFields.add(dbFieldName.isEmpty() ? field.getName() : dbFieldName);
        }
        jsonClassBuilder.add("attributes", (JsonElement)jsonFields);
        jsonClassBuilder.add("labels", (JsonElement)jsonLabels);
        jsonClassBuilder.add("dbFieldNames", (JsonElement)jsonDbFields);
        jsonClassBuilder.add("dbLengths", (JsonElement)dbLengths);
        jsonClassBuilder.add("dbPrecisions", (JsonElement)dbPrecisions);
        jsonClassBuilder.add("dbScales", (JsonElement)dbScales);
        jsonClassBuilder.add("nullables", (JsonElement)nullables);
        jsonClassBuilder.add("requireds", (JsonElement)requireds);
        jsonClassBuilder.add("primaryKeys", (JsonElement)primaryKeys);
        jsonClassBuilder.add("uniqueKeys", (JsonElement)uniqueKeys);
        jsonClassBuilder.add("keyTypes", (JsonElement)keyTypes);
        jsonClassBuilder.add("sequences", (JsonElement)sequences);
        jsonClassBuilder.addProperty("isRest", "true");
        jsonClassBuilder.addProperty("usePhysicalNames", String.valueOf(this.usePhysicalNames));
        jsonClassBuilder.add("foreignKeysName", (JsonElement)foreignKeysName);
        jsonClassBuilder.add("joins", (JsonElement)joins);
        jsonClassBuilder.add("updatable", (JsonElement)updatable);
        jsonClassBuilder.add("insertable", (JsonElement)insertable);
        char firstCharClassName = Character.toLowerCase(className.charAt(0));
        jsonClassBuilder.add("methods", (JsonElement)new JsonArray());
        jsonClassBuilder.addProperty("modelType", this.getModelType(tableName, views));
        return jsonClassBuilder;
    }

    static String getProtocol(String url) {
        String protocol = null;
        if (!StringUtil.isEmpty((String)url) && url.startsWith("jdbc:")) {
            int next;
            int colonCount = 1;
            int protoEnd = next = "jdbc:".length();
            while (colonCount < 3 && next < url.length()) {
                char c;
                if ((c = url.charAt(next++)) == ':') {
                    ++colonCount;
                    protoEnd = next;
                    continue;
                }
                if (c != '@' && c != '/' && c != '\\') continue;
                --next;
                break;
            }
            protocol = url.substring(0, protoEnd);
        }
        return protocol;
    }

    private boolean hasLength(int typeCode) {
        switch (typeCode) {
            case 0: 
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 28: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                return false;
            }
        }
        return true;
    }

    private boolean isBuiltinIdentity(int typeCode) {
        switch (typeCode) {
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 29: {
                return true;
            }
        }
        return false;
    }

    private JsonObject toJointRelationship(FieldMapping fieldMapping, JsonArray jsonCells) {
        JsonObject link = new JsonObject();
        link.addProperty("type", "uml.Composition");
        String runtimeClass = "cronos.widgets.joint.arrow.OneToMany";
        JsonObject target = new JsonObject();
        JsonObject sourceRelation = this.getJsonObjectFromField(fieldMapping.getDeclaringMapping().getResourceName(), jsonCells);
        JsonObject targetRelation = this.getJsonObjectFromField(fieldMapping.getType(), jsonCells);
        if (sourceRelation == null || targetRelation == null) {
            return null;
        }
        target.add("id", sourceRelation.get("id"));
        JsonObject source = new JsonObject();
        source.add("id", targetRelation.get("id"));
        link.add("source", (JsonElement)source);
        link.add("target", (JsonElement)target);
        JsonArray relationFields = new JsonArray();
        relationFields.add(fieldMapping.getName() + ":target");
        link.add("relationFields", (JsonElement)relationFields);
        JsonArray labels = new JsonArray();
        JsonObject label = new JsonObject();
        label.addProperty("position", (Number)0.9);
        JsonObject attrs = new JsonObject();
        JsonObject attrsText = new JsonObject();
        attrsText.addProperty("text", "*");
        attrs.add("text", (JsonElement)attrsText);
        label.add("attrs", (JsonElement)attrs);
        labels.add((JsonElement)label);
        link.add("labels", (JsonElement)labels);
        link.addProperty("id", UUID.randomUUID().toString());
        link.addProperty("runtimeClass", runtimeClass);
        link.addProperty("z", "4");
        JsonObject attrsJson = (JsonObject)new Gson().fromJson("{ \".marker-source\": { \"d\": \"M 40 10 L 20 20 L 0 10 L 20 0 z\", \"fill\": \"black\" }, \".marker-target\": { \"d\": \"\", \"fill\": \"\" }}", JsonObject.class);
        link.add("attrs", (JsonElement)attrsJson);
        return link;
    }

    private String getTableName(String name) {
        if (!StringUtils.isEmpty((CharSequence)name)) {
            if (name.contains(".") && name.indexOf(".") > -1) {
                return name.substring(name.indexOf(".") + 1, name.length());
            }
            return name;
        }
        return "";
    }

    private List<String> selectFields(String tableName, Map<String, List<String>> selectFields) {
        for (String table : selectFields.keySet()) {
            if (!this.getTableName(table).equals(tableName)) continue;
            return selectFields.get(table).stream().map(String::toLowerCase).collect(Collectors.toList());
        }
        return null;
    }

    private JsonObject getJsonObjectFromField(String type, JsonArray jsonCells) {
        for (JsonElement jsonValue : jsonCells) {
            JsonObject cell = (JsonObject)jsonValue;
            if (!cell.get("type").getAsString().equals("uml.Class") || !cell.get("name").getAsString().equals(type)) continue;
            return cell;
        }
        return null;
    }

    private JsonObject getJsonObjectFromField(Class<?> type, JsonArray jsonCells) {
        for (JsonElement jsonValue : jsonCells) {
            JsonObject cell = (JsonObject)jsonValue;
            if (!cell.get("type").getAsString().equals("uml.Class") || !cell.get("name").getAsString().equals(type.getName())) continue;
            return cell;
        }
        return null;
    }

    private JsonObject createRectCell(ReverseEngineeringDataContext dataSource) {
        JsonObject jsonClassBuilder = new JsonObject();
        jsonClassBuilder.addProperty("type", "basic.Rect");
        JsonObject position = new JsonObject();
        position.addProperty("x", (Number)0);
        position.addProperty("y", (Number)0);
        jsonClassBuilder.add("position", (JsonElement)position);
        JsonObject size = new JsonObject();
        size.addProperty("width", (Number)0);
        size.addProperty("height", (Number)0);
        jsonClassBuilder.add("size", (JsonElement)size);
        jsonClassBuilder.addProperty("angle", (Number)0);
        jsonClassBuilder.addProperty("id", "paperCell");
        jsonClassBuilder.addProperty("runtimeClass", "cronos.widgets.joint.uml.Paper");
        jsonClassBuilder.addProperty("dataSource", dataSource.getName());
        jsonClassBuilder.addProperty("z", (Number)1);
        jsonClassBuilder.add("attrs", (JsonElement)new JsonArray());
        return jsonClassBuilder;
    }

    private String getModelType(String tableName, List<String> views) {
        if (!views.isEmpty() && views.indexOf(tableName) > -1) {
            return "View";
        }
        return "Table";
    }

    private Size getSize(ClassMapping mapping) {
        Size size = new Size();
        size.width = 100;
        size.height = 100;
        FieldMetaData[] fields = mapping.getFields();
        if (fields.length > 0) {
            int longestField = 0;
            int total = 0;
            for (FieldMetaData field : fields) {
                if (field.getType() == Set.class) continue;
                ++total;
                longestField = Math.max(longestField, (field.getName() + field.getType().getName()).length());
            }
            size.height = total * 13 + 93;
            size.width = longestField * 6 + 34;
            size.width = Math.max(size.width, (mapping.getResourceName().length() + 16) * 6 + 34);
        }
        return size;
    }

    private JsonObject getJointAttrs(String className, ClassMapping mapping) {
        JsonObject jsonAttrs = new JsonObject();
        JsonObject rect = new JsonObject();
        rect.addProperty("stroke", "yellow");
        rect.addProperty("stroke-width", (Number)2);
        jsonAttrs.add("rect", (JsonElement)rect);
        JsonObject umlClassNameRect = new JsonObject();
        umlClassNameRect.addProperty("height", (Number)40);
        umlClassNameRect.addProperty("transform", "translate(0,0)");
        jsonAttrs.add(".uml-class-name-rect", (JsonElement)umlClassNameRect);
        JsonObject umlClassAttrsRect = new JsonObject();
        umlClassAttrsRect.addProperty("height", (Number)80);
        umlClassAttrsRect.addProperty("transform", "translate(0,40)");
        jsonAttrs.add(".uml-class-attrs-rect", (JsonElement)umlClassAttrsRect);
        JsonObject umlClassMethodsRect = new JsonObject();
        umlClassMethodsRect.addProperty("height", (Number)20);
        umlClassMethodsRect.addProperty("transform", "translate(0,120)");
        jsonAttrs.add(".uml-class-methods-rect", (JsonElement)umlClassMethodsRect);
        JsonObject umlClassNameText = new JsonObject();
        umlClassNameText.addProperty("text", className);
        jsonAttrs.add(".uml-class-name-text", (JsonElement)umlClassNameText);
        StringBuilder jsonFields = new StringBuilder();
        StringBuilder jsonTypes = new StringBuilder();
        for (FieldMetaData field : mapping.getDeclaredFields()) {
            String fieldType = field.getType().getName();
            if (field.getType().isAssignableFrom(Set.class)) continue;
            jsonFields.append(field.getName());
            jsonTypes.append(fieldType + "\n");
        }
        JsonObject umlClassAttrsId = new JsonObject();
        umlClassAttrsId.addProperty("text", jsonFields.toString().trim());
        jsonAttrs.add(".uml-class-attrs-text", (JsonElement)umlClassAttrsId);
        JsonObject umlClassAttrsValue = new JsonObject();
        umlClassAttrsValue.addProperty("text", jsonTypes.toString().trim());
        jsonAttrs.add(".uml-class-attrs-value", (JsonElement)umlClassAttrsValue);
        JsonObject umlClassMethodsText = new JsonObject();
        umlClassMethodsText.addProperty("text", "");
        jsonAttrs.add(".uml-class-methods-text", (JsonElement)umlClassMethodsText);
        return jsonAttrs;
    }

    static {
        try (InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream("java-keywords.rsrc");){
            String[] keywords = StringUtil.split((String)new BufferedReader(new InputStreamReader(in)).readLine(), (String)",", (int)0);
            for (int i = 0; i < keywords.length; i += 2) {
                _javaKeywords.put(keywords[i], keywords[i + 1]);
            }
        }
        catch (IOException ioe) {
            throw new InternalException((Throwable)ioe);
        }
    }

    private static final class Size {
        public int width;
        public int height;

        private Size() {
        }
    }
}

