/*
 * Decompiled with CFR 0.152.
 */
package cronapi.rest.security;

import cronapi.rest.RestHandlerInterceptor;
import cronapi.rest.security.BlocklySecurity;
import cronapi.rest.security.CronappSecurity;
import jakarta.servlet.http.HttpServletRequest;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.authorization.AuthorizationDecision;
import org.springframework.security.authorization.AuthorizationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.access.intercept.RequestAuthorizationContext;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerExecutionChain;
import org.springframework.web.servlet.HandlerMapping;

@Component
public class CronappAuthorizationManager
implements AuthorizationManager<RequestAuthorizationContext> {
    @Generated
    private static final Log log = LogFactory.getLog(CronappAuthorizationManager.class);
    private final List<HandlerMapping> handlerMappings;

    public AuthorizationDecision check(Supplier<Authentication> authentication, RequestAuthorizationContext authorizationContext) {
        HttpServletRequest request = authorizationContext.getRequest();
        HandlerMethod handlerMethod = this.handlerMappings.stream().map(handlerMapping -> {
            try {
                return handlerMapping.getHandler(request);
            }
            catch (Exception e) {
                log.error((Object)"Handler lookup failed", (Throwable)e);
                return null;
            }
        }).filter(Objects::nonNull).map(HandlerExecutionChain::getHandler).filter(HandlerMethod.class::isInstance).map(HandlerMethod.class::cast).filter(RestHandlerInterceptor::isManaged).findFirst().orElse(null);
        if (handlerMethod == null) {
            return null;
        }
        if (this.checkSecurity(authorizationContext.getRequest(), handlerMethod)) {
            return new AuthorizationDecision(true);
        }
        return null;
    }

    private boolean checkSecurity(HttpServletRequest request, HandlerMethod handlerMethod) {
        CronappSecurity beanSecurity;
        String requestMethodSecurity;
        String[] authorities;
        Class beanType = handlerMethod.getBeanType();
        String requestMethod = request.getMethod();
        if (StringUtils.equals((CharSequence)"HEAD", (CharSequence)requestMethod)) {
            requestMethod = "GET";
        }
        if (beanType.isAnnotationPresent(CronappSecurity.class) && !BlocklySecurity.isAuthorized(authorities = (requestMethodSecurity = BlocklySecurity.getRequestMethodSecurity(beanSecurity = beanType.getAnnotation(CronappSecurity.class), requestMethod)).trim().split(";"))) {
            return false;
        }
        Method beanMethod = handlerMethod.getMethod();
        if (beanMethod.isAnnotationPresent(RequestMapping.class)) {
            CronappSecurity beanMethodSecurity = beanMethod.getAnnotation(CronappSecurity.class);
            String requestMethodSecurity2 = BlocklySecurity.getRequestMethodSecurity(beanMethodSecurity, requestMethod);
            String[] authorities2 = requestMethodSecurity2.trim().split(";");
            return BlocklySecurity.isAuthorized(authorities2);
        }
        return true;
    }

    @Generated
    public CronappAuthorizationManager(List<HandlerMapping> handlerMappings) {
        this.handlerMappings = handlerMappings;
    }
}

