/*
 * Decompiled with CFR 0.152.
 */
package cronapi.rest;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import cronapi.ErrorResponse;
import cronapi.QueryManager;
import cronapi.RestClient;
import cronapi.i18n.Messages;
import cronapi.report.DataSourcesInBand;
import cronapi.report.ReportFront;
import cronapi.report.ReportService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/rest"})
public class ReportREST {
    private static final Logger log = LoggerFactory.getLogger(ReportREST.class);
    private ReportService reportService;

    @Autowired
    public ReportREST(ReportService reportService) {
        this.reportService = reportService;
    }

    @RequestMapping(value={"/report"}, method={RequestMethod.POST}, produces={"application/json"})
    public ResponseEntity<ReportFront> getReport(@RequestBody ReportFront reportFront) {
        if (reportFront == null) {
            return ((ResponseEntity.BodyBuilder)ResponseEntity.badRequest().header("Error", new String[]{"Report is null"})).body((Object)new ReportFront());
        }
        log.debug("Get report [" + String.valueOf(reportFront) + "].");
        ReportFront reportResult = this.reportService.getReport(reportFront.getReportName());
        return ResponseEntity.ok().body((Object)reportResult);
    }

    @RequestMapping(value={"/report/contentasstring"}, method={RequestMethod.POST}, produces={"text/plain"})
    public ResponseEntity<String> getContentAsString(@RequestBody ReportFront reportFront, HttpServletResponse response) {
        if (reportFront == null) {
            return ((ResponseEntity.BodyBuilder)ResponseEntity.badRequest().header("Error", new String[]{"Report is null"})).body((Object)"Error read content file");
        }
        String reportName = reportFront.getReportName();
        log.debug("Print report [" + reportName + "]");
        response.setHeader("Content-Disposition", "inline; filename=" + reportName);
        response.setContentType("application/plain");
        String reportResult = this.reportService.getContentReport(reportName);
        ResponseEntity error = this.checkSecurity(reportResult);
        if (error != null) {
            return error;
        }
        return ResponseEntity.ok().body((Object)reportResult);
    }

    private ResponseEntity checkSecurity(String reportResult) {
        String security;
        JsonElement getValue;
        JsonObject reportsJson = (JsonObject)new JsonParser().parse(reportResult);
        JsonElement reportsConfig = reportsJson.get("reportConfig");
        if (!QueryManager.isNull(reportsConfig) && !QueryManager.isNull(reportsConfig.getAsJsonObject().get("restSecurity")) && !QueryManager.isNull(getValue = reportsConfig.getAsJsonObject().get("restSecurity").getAsJsonObject().get("get")) && StringUtils.isNotEmpty((CharSequence)(security = getValue.getAsJsonPrimitive().getAsString()))) {
            String[] roles;
            boolean authorized = false;
            block0: for (String role : roles = security.split(",")) {
                for (GrantedAuthority authority : RestClient.getRestClient().getAuthorities()) {
                    if (!role.trim().equalsIgnoreCase(authority.getAuthority())) continue;
                    authorized = true;
                    continue block0;
                }
            }
            if (!authorized) {
                JsonObject error = new JsonObject();
                error.addProperty("error", Messages.getString("notAllowed"));
                return ResponseEntity.status((int)403).body((Object)error.toString());
            }
        }
        return null;
    }

    @RequestMapping(value={"/report/getdatasourcesparams"}, method={RequestMethod.POST}, produces={"application/json"})
    public ResponseEntity<DataSourcesInBand> getDataSourcesParams(@RequestBody DataSourcesInBand dataSourcesInBand) {
        if (dataSourcesInBand == null) {
            return ((ResponseEntity.BodyBuilder)ResponseEntity.badRequest().header("Error", new String[]{"Datasources is null"})).body((Object)new DataSourcesInBand());
        }
        log.debug("Get datasources params");
        DataSourcesInBand dataSourcesParams = this.reportService.getDataSourcesParams(dataSourcesInBand);
        return ResponseEntity.ok().body((Object)dataSourcesParams);
    }

    @RequestMapping(value={"/report/pdf"}, method={RequestMethod.POST}, produces={"text/plain"})
    public ResponseEntity<byte[]> getPDF(@RequestBody ReportFront reportFront, HttpServletResponse response) {
        if (reportFront == null) {
            return ((ResponseEntity.BodyBuilder)ResponseEntity.badRequest().header("Error", new String[]{"Report is null"})).body((Object)new byte[0]);
        }
        String reportName = reportFront.getReportName();
        log.debug("Print report [" + reportName + "]");
        response.setHeader("Content-Disposition", "inline; filename=" + reportName + ".pdf");
        response.setContentType("application/pdf");
        byte[] reportResult = this.reportService.getPDF(reportFront);
        return ResponseEntity.ok().body((Object)reportResult);
    }

    @ExceptionHandler(value={Throwable.class})
    @ResponseBody
    ResponseEntity<ErrorResponse> handleControllerException(HttpServletRequest req, Throwable ex) {
        ErrorResponse errorResponse = new ErrorResponse(HttpStatus.INTERNAL_SERVER_ERROR.value(), ex, req.getMethod());
        return new ResponseEntity((Object)errorResponse, (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
    }
}

