/*
 * Decompiled with CFR 0.152.
 */
package cronapi.jdbc;

import cronapi.Var;
import cronapi.jdbc.DatabaseMetadata;
import cronapi.jdbc.SQLAnsiMetadata;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.Fetch;
import net.sf.jsqlparser.statement.select.Offset;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import org.apache.commons.lang3.StringUtils;
import org.apache.olingo.odata2.api.edm.EdmEntityType;
import org.apache.olingo.odata2.core.edm.provider.EdmSimplePropertyImplProv;
import org.apache.olingo.odata2.jpa.processor.core.ExpressionProvider;
import org.apache.olingo.odata2.jpa.processor.core.ExpressionProviderFactory;
import org.apache.olingo.odata2.jpa.processor.core.model.JPAEdmMappingImpl;
import org.apache.openjpa.jdbc.conf.JDBCConfigurationImpl;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.jdbc.sql.OracleDictionary;
import org.apache.openjpa.lib.conf.Configuration;

public class OracleMetadata
extends SQLAnsiMetadata
implements DatabaseMetadata {
    private static final OracleDictionary DICTIONARY = new OracleDictionary();

    @Override
    public String limit(Statement statement, Connection connection, Integer top, Integer skip) throws Exception {
        PlainSelect selectStatement;
        boolean canLimit = true;
        if (((Select)statement).getSelectBody() instanceof PlainSelect && (selectStatement = (PlainSelect)((Select)statement).getSelectBody()).getFromItem() instanceof Table && ((Table)selectStatement.getFromItem()).getName().equalsIgnoreCase("DUAL")) {
            canLimit = false;
        }
        if (canLimit) {
            PlainSelect select = (PlainSelect)((Select)statement).getSelectBody();
            Offset offset = new Offset().withOffsetParam("ROWS");
            offset.setOffset((Expression)new LongValue((long)skip.intValue()));
            select.setOffset(offset);
            Fetch fetch = new Fetch().withFetchParam("ROWS");
            fetch.setRowCount((long)top.intValue());
            select.setFetch(fetch);
        }
        String dbVersion = connection.getMetaData().getDatabaseProductVersion();
        boolean isOracle12cOrAbove = dbVersion.matches(".*\\b(12|13|14|18|19|21|23)\\b.*");
        Object sql = statement.toString();
        if (isOracle12cOrAbove && ((String)sql).matches("(?i).*FETCH\\s+NEXT\\s+\\d+\\s+ROWS(?!\\s+ONLY).*")) {
            sql = (String)sql + " ONLY";
        }
        return sql;
    }

    @Override
    public String count(Statement statement, Connection connection) {
        PlainSelect select = (PlainSelect)((Select)statement).getSelectBody();
        select.setOrderByElements(List.of());
        String sql = "select count(*) AS CRONAPP_COUNT from (" + String.valueOf(statement) + ") CRONAPP_COUNT_SELECT";
        return sql;
    }

    @Override
    public DBDictionary getDictionary(Connection connection) throws SQLException {
        return DICTIONARY;
    }

    @Override
    public Map<String, Object> getGenerated(EdmEntityType entity, PreparedStatement ps, Connection connection) throws Exception {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (String name : entity.getPropertyNames()) {
            EdmSimplePropertyImplProv property = (EdmSimplePropertyImplProv)entity.getProperty(name);
            if (property.getFacets() == null || !property.getFacets().isAutoGenerated() || !StringUtils.isNotBlank((CharSequence)property.getFacets().getDefaultValue()) || !property.getFacets().getDefaultValue().contains(".nextval")) continue;
            String seq = property.getFacets().getDefaultValue().replace(".nextval", ".currval");
            PreparedStatement stmnt = connection.prepareStatement("SELECT " + seq + " FROM DUAL");
            try {
                ResultSet rs = stmnt.executeQuery();
                try {
                    if (!rs.next()) continue;
                    map.put(property.getName(), Var.valueOf(rs.getObject(1)).getObject(((JPAEdmMappingImpl)property.getMapping()).getJPAType()));
                }
                finally {
                    if (rs == null) continue;
                    rs.close();
                }
            }
            finally {
                if (stmnt == null) continue;
                stmnt.close();
            }
        }
        return map;
    }

    @Override
    public ExpressionProvider getExpressionProvider() {
        return ExpressionProviderFactory.getProvider((String)"Oracle");
    }

    static {
        DICTIONARY.setConfiguration((Configuration)new JDBCConfigurationImpl());
    }
}

