/*
 * Decompiled with CFR 0.152.
 */
package cronapi.database;

import cronapi.AppConfig;
import cronapi.RestClient;
import cronapi.database.TenantService;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.FlushModeType;
import jakarta.persistence.Persistence;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.persistence.internal.jpa.deployment.PersistenceUnitProcessor;
import org.eclipse.persistence.internal.jpa.deployment.SEPersistenceUnitInfo;
import org.eclipse.persistence.jpa.Archive;

public class TransactionManager {
    public static final String AUTO = "AUTO";
    private static ThreadLocal<Map<String, EntityManager>> CACHE_NAMESPACE = new ThreadLocal();

    public static void addNamespace(String namespace, EntityManager entityManager) {
        Map<String, EntityManager> map = CACHE_NAMESPACE.get();
        if (map == null) {
            map = new HashMap<String, EntityManager>();
            CACHE_NAMESPACE.set(map);
        }
        map.put(namespace, entityManager);
    }

    public static EntityManager getEntityManager(Class domainClass) {
        return TransactionManager.getEntityManager(domainClass, true);
    }

    public static EntityManager getEntityManager(Class domainClass, boolean cache) {
        String namespace = domainClass.getPackage().getName().replace(".entity", "");
        return TransactionManager.getEntityManager(namespace, cache);
    }

    public static EntityManager getEntityManager(String namespace, boolean cache) {
        TenantService tenantService;
        EntityManager emNamespace;
        Map<String, EntityManager> mapNamespace = CACHE_NAMESPACE.get();
        if (mapNamespace == null) {
            mapNamespace = new HashMap<String, EntityManager>();
            CACHE_NAMESPACE.set(mapNamespace);
        }
        if (mapNamespace != null && cache && (emNamespace = mapNamespace.get(namespace)) != null && emNamespace.isOpen()) {
            return emNamespace;
        }
        EntityManagerFactory factory = TransactionManager.findEntityManagerFactory(namespace);
        EntityManager em = factory.createEntityManager();
        em.setFlushMode(AppConfig.flushMode());
        if (cache) {
            CACHE_NAMESPACE.get().put(namespace, em);
        }
        if ((tenantService = RestClient.getRestClient().getTenantService()) != null && tenantService.getContextIds() != null) {
            Set<String> keySet = tenantService.getContextIds().keySet();
            for (String key : keySet) {
                em.setProperty(key, tenantService.getId(key));
            }
        }
        if (!cache) {
            em.setProperty("eclipselink.query-results-cache", (Object)"false");
            em.setProperty("eclipselink.cache.shared.default", (Object)"false");
        }
        return em;
    }

    public static EntityManagerFactory findEntityManagerFactory(Class domainClass) {
        String namespace = domainClass.getPackage().getName().replace(".entity", "");
        return TransactionManager.findEntityManagerFactory(namespace);
    }

    public static EntityManagerFactory findEntityManagerFactory(String namespace) {
        Set archives = PersistenceUnitProcessor.findPersistenceArchives();
        for (Archive archive : archives) {
            List persistenceUnitInfos = PersistenceUnitProcessor.getPersistenceUnits((Archive)archive, (ClassLoader)Thread.currentThread().getContextClassLoader());
            for (SEPersistenceUnitInfo pui : persistenceUnitInfos) {
                if (!pui.getPersistenceUnitName().equals(namespace)) continue;
                EntityManagerFactory factory = Persistence.createEntityManagerFactory((String)namespace);
                return factory;
            }
        }
        return null;
    }

    public static void commit(Class domainClass) {
        EntityManager em = TransactionManager.getEntityManager(domainClass);
        if (em != null && em.getTransaction().isActive()) {
            em.getTransaction().commit();
        }
    }

    public static void commit(String namespace) {
        EntityManager em = TransactionManager.getEntityManager(namespace, true);
        if (em != null && em.getTransaction().isActive()) {
            em.getTransaction().commit();
        }
    }

    public static void flush(Class domainClass) {
        EntityManager em = TransactionManager.getEntityManager(domainClass);
        if (em != null && em.getTransaction().isActive()) {
            em.flush();
        }
    }

    public static void flush(String namespace) {
        EntityManager em = TransactionManager.getEntityManager(namespace, true);
        if (em != null && em.getTransaction().isActive()) {
            em.flush();
        }
    }

    public static void begin(Class domainClass) {
        EntityManager em = TransactionManager.getEntityManager(domainClass);
        if (em != null && !em.getTransaction().isActive()) {
            em.getTransaction().begin();
        }
    }

    public static void begin(String namespace) {
        EntityManager em = TransactionManager.getEntityManager(namespace, true);
        if (em != null && !em.getTransaction().isActive()) {
            em.getTransaction().begin();
        }
    }

    public static void rollback(Class domainClass) {
        EntityManager em = TransactionManager.getEntityManager(domainClass);
        if (em != null && em.getTransaction().isActive()) {
            em.getTransaction().rollback();
        }
    }

    public static void rollback(String namespace) {
        EntityManager em = TransactionManager.getEntityManager(namespace, true);
        if (em != null && em.getTransaction().isActive()) {
            em.getTransaction().rollback();
        }
    }

    public static void close(Class domainClass) {
        EntityManager em = TransactionManager.getEntityManager(domainClass);
        if (em != null) {
            em.clear();
            em.close();
        }
    }

    public static void close(String namespace) {
        EntityManager em = TransactionManager.getEntityManager(namespace, true);
        if (em != null) {
            em.clear();
            em.close();
        }
    }

    public static void commit() {
        Map<String, EntityManager> mapNamespace = CACHE_NAMESPACE.get();
        if (mapNamespace != null) {
            for (EntityManager em : mapNamespace.values()) {
                if (!em.getTransaction().isActive()) continue;
                em.getTransaction().commit();
            }
        }
    }

    public static void flush() {
        Map<String, EntityManager> mapNamespace = CACHE_NAMESPACE.get();
        if (mapNamespace != null) {
            for (EntityManager em : mapNamespace.values()) {
                em.flush();
            }
        }
    }

    public static void rollback() {
        Map<String, EntityManager> mapNamespace = CACHE_NAMESPACE.get();
        if (mapNamespace != null) {
            for (EntityManager em : mapNamespace.values()) {
                if (!em.getTransaction().isActive()) continue;
                em.getTransaction().rollback();
            }
        }
    }

    public static void close() {
        Map<String, EntityManager> mapNamespace = CACHE_NAMESPACE.get();
        if (mapNamespace != null) {
            for (EntityManager em : mapNamespace.values()) {
                if (!em.isOpen()) continue;
                em.clear();
                em.close();
            }
        }
    }

    public static void clear() {
        Map<String, EntityManager> map = CACHE_NAMESPACE.get();
        if (map != null) {
            for (EntityManager em : map.values()) {
                try {
                    if (!em.isOpen()) continue;
                    em.clear();
                }
                catch (Exception exception) {}
            }
            map.clear();
        }
        CACHE_NAMESPACE.set(null);
        CACHE_NAMESPACE.remove();
    }

    public static void setFlushMode(String namespace, String flushMode) {
        EntityManager em = TransactionManager.getEntityManager(namespace, true);
        if (AUTO.equalsIgnoreCase(flushMode)) {
            em.setFlushMode(FlushModeType.AUTO);
        } else {
            em.setFlushMode(FlushModeType.COMMIT);
        }
    }
}

