/*
 * Decompiled with CFR 0.152.
 */
package cronapi.database;

import com.fasterxml.jackson.annotation.JsonIgnore;
import cronapi.database.FieldMetadata;
import cronapi.database.RelationMetadata;
import cronapi.database.TransactionManager;
import jakarta.persistence.EntityManager;
import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.EntityType;
import jakarta.persistence.metamodel.ManagedType;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class EntityMetadata {
    private String name;
    private String simpleName;
    private String link;
    private String idLink;
    private String findLink;
    private List<FieldMetadata> fields = new ArrayList<FieldMetadata>();
    private EntityManager em;
    private Map<String, RelationMetadata> relations = new LinkedHashMap<String, RelationMetadata>();

    public EntityMetadata(String domainClass) {
        try {
            this.construct(Class.forName(domainClass), true);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public EntityMetadata(Class domainClass) {
        this.construct(domainClass, true);
    }

    public EntityMetadata(ManagedType type, boolean detectRelations) {
        try {
            this.construct(Class.forName(type.getJavaType().getCanonicalName()), detectRelations);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private void construct(Class domainClass, boolean detectRelations) {
        this.em = TransactionManager.getEntityManager(domainClass);
        EntityType type = this.em.getMetamodel().entity(domainClass);
        this.name = type.getJavaType().getCanonicalName();
        this.simpleName = type.getName();
        if (detectRelations) {
            this.link = "/cronapi/data/" + this.name + "/crud/";
        }
        this.findLink = this.link;
        this.idLink = "";
        for (Object o : type.getAttributes()) {
            Attribute attr = (Attribute)o;
            FieldMetadata field = new FieldMetadata(attr);
            this.fields.add(field);
            if (!field.isId()) continue;
            this.findLink = this.findLink + "{" + this.simpleName + ":" + field.getName() + "}/";
            this.idLink = this.idLink + "{" + this.simpleName + ":" + field.getName() + "}/";
        }
        if (detectRelations) {
            for (ManagedType managedType : this.em.getMetamodel().getManagedTypes()) {
                this.checkReverseField(domainClass, managedType);
            }
        }
    }

    @JsonIgnore
    public String getIdLink() {
        return this.idLink;
    }

    private ManagedType findManagedType(Class javaType) {
        for (ManagedType managedType : this.em.getMetamodel().getManagedTypes()) {
            if (managedType.getJavaType() != javaType) continue;
            return managedType;
        }
        return null;
    }

    private void checkReverseField(Class domainClass, ManagedType managedType) {
        for (Object obj : managedType.getAttributes()) {
            Attribute attr = (Attribute)obj;
            if (attr.getJavaType() != domainClass) continue;
            RelationMetadata relation = new RelationMetadata(this, attr, managedType, null, null);
            this.relations.put(relation.getId(), relation);
            for (Object obj2 : managedType.getAttributes()) {
                Attribute attr2 = (Attribute)obj2;
                if (attr2.getJavaType() == domainClass || !attr2.isAssociation()) continue;
                RelationMetadata relation2 = new RelationMetadata(this, attr2, this.findManagedType(attr2.getJavaType()), attr, managedType);
                this.relations.put(relation2.getId(), relation2);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public String getLink() {
        return this.link;
    }

    public List<FieldMetadata> getFields() {
        return this.fields;
    }

    public Map<String, RelationMetadata> getRelations() {
        return this.relations;
    }

    public String getFindLink() {
        return this.findLink;
    }
}

