/*
 * Decompiled with CFR 0.152.
 */
package cronapi.database;

import cronapi.RestClient;
import cronapi.Var;
import cronapi.database.TransactionManager;
import cronapi.rest.security.CronappSecurity;
import jakarta.persistence.EntityManager;
import jakarta.persistence.metamodel.EntityType;
import jakarta.persistence.metamodel.SingularAttribute;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.springframework.security.core.GrantedAuthority;

public class DataSourceFilter {
    private LinkedList<DataSourceFilterItem> items = new LinkedList();
    private LinkedList<DataSourceOrderItem> orders = new LinkedList();
    private String type = "AND";
    private String appliedJpql;
    private Var[] appliedParams;

    private DataSourceFilter(String filter, String order, boolean caseInsensitive) {
        String[] values;
        if (filter != null && !filter.trim().isEmpty() && (values = filter.trim().split(";")).length > 0) {
            for (String v : values) {
                String operation;
                boolean cs = caseInsensitive;
                String[] pair = null;
                if (v.contains("@=")) {
                    pair = v.trim().split("@=");
                    operation = "LIKE";
                } else if (v.contains("<=")) {
                    pair = v.trim().split("<=");
                    operation = "<=";
                } else if (v.contains(">=")) {
                    pair = v.trim().split(">=");
                    operation = ">=";
                } else if (v.contains(">")) {
                    pair = v.trim().split(">");
                    operation = ">";
                } else if (v.contains("<")) {
                    pair = v.trim().split("<");
                    operation = "<";
                } else {
                    pair = v.trim().split("=");
                    operation = "=";
                }
                pair[0] = pair[0].trim();
                if (pair[0].endsWith("/i")) {
                    cs = true;
                    pair[0] = pair[0].substring(0, pair[0].length() - 2);
                }
                if (values.length == 1 && pair.length == 1) {
                    this.items.add(new DataSourceFilterItem("*", Var.valueOf(Var.deserialize(pair[0])), "LIKE", Var.deserializeType(pair[0]), cs));
                    break;
                }
                if (pair.length <= 0 || pair[0].trim().isEmpty()) continue;
                if (pair.length == 1) {
                    this.items.add(new DataSourceFilterItem(pair[0], Var.VAR_NULL, operation, "text", cs));
                }
                if (pair.length <= 1) continue;
                this.items.add(new DataSourceFilterItem(pair[0], Var.valueOf(Var.deserialize(pair[1])), operation, Var.deserializeType(pair[1]), cs));
            }
        }
        if (order != null && !order.trim().isEmpty() && (values = order.trim().split(";")).length > 0) {
            for (String v : values) {
                String[] pair = v.trim().split("\\|");
                if (pair.length == 1) {
                    this.orders.add(new DataSourceOrderItem(pair[0], "ASC"));
                }
                if (pair.length != 2) continue;
                this.orders.add(new DataSourceOrderItem(pair[0], pair[1]));
            }
        }
    }

    public static DataSourceFilter getInstance(String filter, String order, String filterType, boolean caseInsensitive) {
        if (filter != null && !filter.trim().isEmpty() || order != null && !order.trim().isEmpty()) {
            DataSourceFilter dsFilter = new DataSourceFilter(filter, order, caseInsensitive);
            if (filterType != null) {
                dsFilter.setType(filterType);
            }
            return dsFilter;
        }
        return null;
    }

    public LinkedList<DataSourceFilterItem> getItems() {
        return this.items;
    }

    public void setItems(LinkedList<DataSourceFilterItem> items) {
        this.items = items;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        if (type.equalsIgnoreCase("or") || type.equalsIgnoreCase("and")) {
            this.type = type;
        }
    }

    public String getAppliedJpql() {
        return this.appliedJpql;
    }

    public Var[] getAppliedParams() {
        return this.appliedParams;
    }

    public List<String> findSearchables(Object obj, boolean filterWithAnnotation) {
        ArrayList<String> searchable = new ArrayList<String>();
        String baseDomain = obj instanceof Class ? ((Class)obj).getName() : obj.getClass().getName();
        HashSet<String> processed = new HashSet<String>();
        this.findSearchables(obj, filterWithAnnotation, searchable, baseDomain, null, processed);
        return searchable;
    }

    public void findSearchables(Object obj, boolean filterWithAnnotation, List<String> searchable, String baseDomain, String baseAttribute, Set<String> processed) {
        if (baseAttribute == null) {
            baseAttribute = "";
        }
        Class<?> clazz = obj = obj instanceof Class ? (Class<?>)obj : obj.getClass();
        if (processed.contains(obj.getName())) {
            return;
        }
        Field[] fields = obj.getDeclaredFields();
        EntityManager em = TransactionManager.getEntityManager(obj);
        EntityType type = em.getMetamodel().entity(obj);
        processed.add(obj.getName());
        for (Field f : fields) {
            CronappSecurity security;
            String authoritiesStr;
            boolean contains = false;
            SingularAttribute attrCurrent = null;
            for (Object attrObj : type.getAttributes()) {
                SingularAttribute attr = (SingularAttribute)attrObj;
                if (!attr.getName().equalsIgnoreCase(f.getName())) continue;
                contains = true;
                attrCurrent = attr;
            }
            if (!contains) continue;
            CronappSecurity annotation = f.getAnnotation(CronappSecurity.class);
            boolean authorized = true;
            if (annotation != null && (authoritiesStr = (security = annotation).filter()) != null && !authoritiesStr.trim().isEmpty()) {
                String[] authorities;
                authorized = false;
                block2: for (String role : authorities = authoritiesStr.trim().split(";")) {
                    if (role.equalsIgnoreCase("authenticated")) {
                        boolean bl = authorized = RestClient.getRestClient().getUser() != null;
                        if (authorized) break;
                    }
                    if (role.equalsIgnoreCase("permitAll") || role.equalsIgnoreCase("public")) {
                        authorized = true;
                        break;
                    }
                    for (GrantedAuthority authority : RestClient.getRestClient().getAuthorities()) {
                        if (!role.equalsIgnoreCase(authority.getAuthority())) continue;
                        authorized = true;
                        continue block2;
                    }
                }
            }
            if (!authorized) continue;
            if (filterWithAnnotation) {
                if (f.getAnnotation(CronappSecurity.class) != null) {
                    searchable.add(this.getNameWithBaseAttribute(baseAttribute, f.getName()));
                }
            } else {
                searchable.add(this.getNameWithBaseAttribute(baseAttribute, f.getName()));
            }
            if (!attrCurrent.isAssociation()) continue;
            Class association = attrCurrent.getType().getJavaType();
            this.findSearchables(association, filterWithAnnotation, searchable, baseDomain, this.getNameWithBaseAttribute(baseAttribute, f.getName()), processed);
        }
    }

    public String getNameWithBaseAttribute(String baseAttribute, String attribute) {
        if (baseAttribute != null && baseAttribute.length() > 0) {
            return String.format("%s.%s", baseAttribute, attribute);
        }
        return attribute;
    }

    public void applyTo(Class domainClass, String jpql, Var[] params) {
    }

    private void setTypeBasedOnItemsValue() {
        boolean isSameValue = true;
        Iterator iterator = this.items.iterator();
        if (iterator.hasNext()) {
            DataSourceFilterItem item = (DataSourceFilterItem)iterator.next();
            for (DataSourceFilterItem itemToCheck : this.items) {
                if (item.value.getObjectAsString().equals(itemToCheck.value.getObjectAsString())) continue;
                isSameValue = false;
                break;
            }
        }
        this.type = isSameValue ? "or" : "and";
    }

    public static class DataSourceFilterItem {
        public String key;
        public Var value;
        public String operation = "=";
        public String dataType = "text";
        public boolean caseInsensitive = false;

        public DataSourceFilterItem(String key, Var value, String operation, String dataType, boolean caseInsensitive) {
            this.key = key;
            this.value = value;
            if (dataType.equals("text") && caseInsensitive) {
                this.value = Var.valueOf(this.value.getObjectAsString().toLowerCase());
                this.caseInsensitive = true;
            }
            if (operation.equalsIgnoreCase("=") || operation.equalsIgnoreCase("like") || operation.equalsIgnoreCase(">") || operation.equalsIgnoreCase("<") || operation.equalsIgnoreCase(">=") || operation.equalsIgnoreCase("<=")) {
                this.operation = operation;
            }
            this.dataType = dataType;
        }
    }

    public static class DataSourceOrderItem {
        public String key;
        public String type = "ASC";

        public DataSourceOrderItem(String key, String type) {
            this.key = key;
            if (type.equalsIgnoreCase("asc") || type.equalsIgnoreCase("desc")) {
                this.type = type;
            }
        }
    }
}

