/*
 * Decompiled with CFR 0.152.
 */
package cronapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.CalendarSerializer;
import com.fasterxml.jackson.databind.util.ISO8601DateFormat;
import com.fasterxml.jackson.databind.util.ISO8601Utils;
import com.google.gson.JsonElement;
import cronapi.CronapiFilter;
import cronapi.RestClient;
import cronapi.ToStringSerializer;
import cronapi.Var;
import cronapi.VarDeserializer;
import cronapi.serialization.CronappModule;
import jakarta.servlet.Filter;
import jakarta.servlet.MultipartConfigElement;
import java.io.IOException;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.util.Calendar;
import java.util.Date;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.MultipartConfigFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.util.unit.DataSize;

@Configuration
public class CronapiConfigurator {
    public static String ENCODING = "UTF-8";

    @Bean
    public FilterRegistrationBean userInsertingMdcFilterRegistrationBean() {
        FilterRegistrationBean registrationBean = new FilterRegistrationBean();
        registrationBean.setFilter((Filter)new CronapiFilter());
        registrationBean.setOrder(-2147483647);
        return registrationBean;
    }

    @Bean
    public Jackson2ObjectMapperBuilder objectMapperBuilder() {
        Jackson2ObjectMapperBuilder builder = new Jackson2ObjectMapperBuilder();
        builder.serializationInclusion(JsonInclude.Include.NON_NULL);
        builder.deserializerByType(Var.class, (JsonDeserializer)new VarDeserializer());
        builder.serializerByType(JsonElement.class, (JsonSerializer)new ToStringSerializer());
        builder.serializerByType(Calendar.class, (JsonSerializer)new CalendarSerializer(){

            public void serialize(Calendar value, JsonGenerator gen, SerializerProvider provider) throws IOException {
                if (RestClient.getRestClient() != null && RestClient.getRestClient().getRequest() != null && ("true".equals(RestClient.getRestClient().getRequest().getHeader("toJS")) || "true".equals(RestClient.getRestClient().getRequest().getParameter("toJS")))) {
                    gen.writeRawValue("new Date(\"" + ISO8601Utils.format((Date)value.getTime(), (boolean)true) + "\")");
                } else {
                    gen.writeString(ISO8601Utils.format((Date)value.getTime(), (boolean)true));
                }
            }
        });
        builder.dateFormat((DateFormat)new ISO8601DateFormat(){

            public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition fieldPosition) {
                String value = ISO8601Utils.format((Date)date, (boolean)true);
                toAppendTo.append(value);
                return toAppendTo;
            }
        });
        builder.modulesToInstall(new Module[]{new CronappModule()});
        return builder;
    }

    @Bean
    public MultipartConfigElement multipartConfigElement(@Value(value="${cronapp.request.maxFileSize:#{null}}") Optional<Long> maxFileSize, @Value(value="${cronapp.request.maxRequestSize:#{null}}") Optional<Long> maxRequestSize) {
        MultipartConfigFactory factory = new MultipartConfigFactory();
        factory.setMaxFileSize(DataSize.ofBytes((long)maxFileSize.orElse(0x1900000000L)));
        factory.setMaxRequestSize(DataSize.ofBytes((long)maxRequestSize.orElse(0x1900000000L)));
        return factory.createMultipartConfig();
    }
}

