/*
 * Decompiled with CFR 0.152.
 */
package cronapi.chatbot.telegram;

import cronapi.chatbot.Messenger;
import cronapi.chatbot.assistant.WatsonAssistant;
import cronapi.chatbot.elements.UserProfile;
import cronapi.chatbot.telegram.TelegramMessenger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.telegram.telegrambots.api.objects.Update;

@RestController
@RequestMapping(value={"/api/cronapi/chatbot/telegram"})
public class TelegramWebhook {
    private final Messenger messenger;
    private final WatsonAssistant assistant;
    private UserProfile user;

    @Autowired
    public TelegramWebhook(TelegramMessenger messenger, WatsonAssistant assistant) {
        this.messenger = messenger;
        this.assistant = assistant;
    }

    @RequestMapping(method={RequestMethod.POST})
    public ResponseEntity<Void> handleCallback(@RequestBody Update update) {
        String chat = null;
        String message = null;
        if (update.getCallbackQuery() != null && update.getCallbackQuery().getMessage() != null) {
            message = update.getCallbackQuery().getData();
            chat = String.valueOf(update.getCallbackQuery().getFrom().getId());
        }
        if (chat == null) {
            chat = String.valueOf(update.getMessage().getChat().getId());
        }
        if (message == null) {
            message = update.getMessage().getText();
        }
        if (update.getMessage() != null && update.getMessage().getFrom() != null) {
            this.user = new UserProfile(update.getMessage().getFrom().getFirstName(), update.getMessage().getFrom().getLastName());
        } else if (update.getCallbackQuery().getFrom() != null) {
            this.user = new UserProfile(update.getCallbackQuery().getFrom().getFirstName(), update.getCallbackQuery().getFrom().getLastName());
        }
        if (message == null) {
            if (update.getMessage().getVoice() != null) {
                message = "++user_input:AUDIO++";
            } else if (update.getMessage().getPhoto() != null) {
                message = "++user_input:PHOTO++";
            } else if (update.getMessage().getDocument() != null) {
                message = "++user_input:DOCUMENT++";
            }
        }
        this.messenger.sendTypingOn(chat);
        this.assistant.handleTextMessage(chat, message, this.messenger, this.user);
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).build();
    }

    @RequestMapping(method={RequestMethod.GET})
    public ResponseEntity<String> verifyWebhook() {
        return ResponseEntity.ok((Object)"");
    }
}

