/*
 * Decompiled with CFR 0.152.
 */
package cronapi.chatbot;

import com.ibm.watson.assistant.v1.model.MessageResponse;
import cronapi.chatbot.ChatBotConfiguration;
import cronapi.chatbot.ChatBotException;
import cronapi.chatbot.elements.Carousel;
import cronapi.chatbot.elements.GroupedButton;
import cronapi.chatbot.elements.LabelUrl;
import cronapi.chatbot.elements.Location;
import cronapi.chatbot.elements.QuickReply;
import cronapi.chatbot.elements.TypeUrl;
import java.io.IOException;
import java.util.List;

public interface Messenger {
    public static final String AUDIO = "++user_input:AUDIO++";
    public static final String PHOTO = "++user_input:PHOTO++";
    public static final String DOCUMENT = "++user_input:DOCUMENT++";
    public static final String THUMB_UP = "++user_input:THUMB_UP++";

    public String getPlatform();

    default public void sendWatsonMessage(String conversationId, MessageResponse messageResponse) {
        List outputTextList = messageResponse.getOutput().getText();
        for (int i = 0; i < outputTextList.size(); ++i) {
            String outputText = (String)outputTextList.get(i);
            if (i == outputTextList.size() - 1 && (messageResponse.getContext().get("location") != null || messageResponse.getContext().get("carousel") != null || messageResponse.getContext().get("quick_reply") != null || messageResponse.getContext().get("send_file") != null || messageResponse.getContext().get("send_image") != null || messageResponse.getContext().get("send_button") != null)) {
                try {
                    List labelUrlList;
                    String labelUrl;
                    if (messageResponse.getContext().get("location") != null) {
                        String locationJson = ChatBotConfiguration.OBJECT_MAPPER.writeValueAsString(messageResponse.getContext().get("location"));
                        Location location = (Location)ChatBotConfiguration.OBJECT_MAPPER.readValue(locationJson, Location.class);
                        this.sendLocation(conversationId, location);
                    }
                    if (messageResponse.getContext().get("carousel") != null) {
                        String carousel = ChatBotConfiguration.OBJECT_MAPPER.writeValueAsString(messageResponse.getContext().get("carousel"));
                        List carouselList = (List)ChatBotConfiguration.OBJECT_MAPPER.readValue(carousel, ChatBotConfiguration.TYPE_LIST_CAROUSEL);
                        this.sendCarousel(conversationId, carouselList);
                    }
                    if (messageResponse.getContext().get("send_image") != null) {
                        labelUrl = ChatBotConfiguration.OBJECT_MAPPER.writeValueAsString(messageResponse.getContext().get("send_image"));
                        labelUrlList = (List)ChatBotConfiguration.OBJECT_MAPPER.readValue(labelUrl, ChatBotConfiguration.TYPE_LIST_LABELURL);
                        this.sendImageMessage(conversationId, labelUrlList);
                    }
                    if (messageResponse.getContext().get("send_file") != null) {
                        labelUrl = ChatBotConfiguration.OBJECT_MAPPER.writeValueAsString(messageResponse.getContext().get("send_file"));
                        labelUrlList = (List)ChatBotConfiguration.OBJECT_MAPPER.readValue(labelUrl, ChatBotConfiguration.TYPE_LIST_LABELURL);
                        this.sendFileMessage(conversationId, labelUrlList);
                    }
                    if (messageResponse.getContext().get("send_button") != null) {
                        String sendButton = ChatBotConfiguration.OBJECT_MAPPER.writeValueAsString(messageResponse.getContext().get("send_button"));
                        GroupedButton groupedButton = (GroupedButton)ChatBotConfiguration.OBJECT_MAPPER.readValue(sendButton, GroupedButton.class);
                        this.sendButtonMessage(conversationId, groupedButton);
                    }
                    if (messageResponse.getContext().get("quick_reply") != null) {
                        String quickReply = ChatBotConfiguration.OBJECT_MAPPER.writeValueAsString(messageResponse.getContext().get("quick_reply"));
                        List quickReplyList = (List)ChatBotConfiguration.OBJECT_MAPPER.readValue(quickReply, ChatBotConfiguration.TYPE_LIST_QUICKREPLY);
                        if (quickReplyList.isEmpty()) {
                            this.sendTextMessage(conversationId, outputText);
                            continue;
                        }
                        this.sendQuickReply(conversationId, outputText, quickReplyList);
                        continue;
                    }
                    this.sendTextMessage(conversationId, outputText);
                    continue;
                }
                catch (IOException e) {
                    throw new ChatBotException(e);
                }
            }
            this.sendTextMessage(conversationId, outputText);
        }
    }

    public void sendLocation(String var1, Location var2);

    public void sendCarousel(String var1, List<Carousel> var2);

    public void sendQuickReply(String var1, String var2, List<QuickReply> var3);

    public void sendTextMessage(String var1, String var2);

    public String getUrlFromLocation(Location var1, TypeUrl var2);

    default public void sendTypingOn(String conversationId) {
    }

    default public void sendTypingOff(String conversationId) {
    }

    default public void sendImageMessage(String conversationId, List<LabelUrl> labelUrlList) {
    }

    default public void sendFileMessage(String conversationId, List<LabelUrl> labelUrlList) {
    }

    default public void sendButtonMessage(String conversationId, GroupedButton groupedButton) {
    }
}

