/*
 * Decompiled with CFR 0.152.
 */
package cronapi.chatbot.facebook;

import com.github.messenger4j.Messenger;
import com.github.messenger4j.exception.MessengerVerificationException;
import com.github.messenger4j.webhook.event.AttachmentMessageEvent;
import com.github.messenger4j.webhook.event.PostbackEvent;
import com.github.messenger4j.webhook.event.QuickReplyMessageEvent;
import com.github.messenger4j.webhook.event.TextMessageEvent;
import com.github.messenger4j.webhook.event.attachment.Attachment;
import com.github.messenger4j.webhook.event.attachment.RichMediaAttachment;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import cronapi.chatbot.assistant.WatsonAssistant;
import cronapi.chatbot.elements.UserProfile;
import cronapi.chatbot.facebook.FacebookMessenger;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Map;
import java.util.Optional;
import java.util.Scanner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/cronapi/chatbot/facebook"})
public class FacebookMessengerWebhook {
    private final Logger LOGGER = Logger.getLogger(FacebookMessengerWebhook.class.getName());
    private final Messenger messenger;
    private final FacebookMessenger facebookMessenger;
    private final WatsonAssistant assistant;
    private final String pageAccessToken;
    private Map<String, UserProfile> userProfCache = new ConcurrentHashMap<String, UserProfile>();

    @Autowired
    public FacebookMessengerWebhook(Messenger messenger, FacebookMessenger facebookMessenger, WatsonAssistant assistant, @Value(value="${chatbot.facebook.page}") String pageAccessToken) {
        this.messenger = messenger;
        this.facebookMessenger = facebookMessenger;
        this.assistant = assistant;
        this.pageAccessToken = pageAccessToken;
    }

    @RequestMapping(method={RequestMethod.GET})
    public ResponseEntity<String> verifyWebhook(@RequestParam(value="hub.mode") String mode, @RequestParam(value="hub.verify_token") String verifyToken, @RequestParam(value="hub.challenge") String challenge) {
        this.LOGGER.fine(() -> String.format("Received Facebook verification request - mode: %s | verifyToken: %s | challenge: %s", mode, verifyToken, challenge));
        try {
            this.messenger.verifyWebhook(mode, verifyToken);
            return ResponseEntity.ok((Object)challenge);
        }
        catch (MessengerVerificationException e) {
            this.LOGGER.warning(() -> String.format("Facebook verification failed: %s", e.getMessage()));
            return ResponseEntity.status((HttpStatus)HttpStatus.FORBIDDEN).body((Object)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserProfile queryUserProfile(String userId) throws IOException {
        if (this.userProfCache.containsKey(userId)) {
            return this.userProfCache.get(userId);
        }
        Map<String, UserProfile> map = this.userProfCache;
        synchronized (map) {
            UserProfile userProfile;
            if (this.userProfCache.containsKey(userId)) {
                return this.userProfCache.get(userId);
            }
            String url = String.format("https://graph.facebook.com/v2.11/%s?fields=first_name,last_name&access_token=%s", userId, this.pageAccessToken);
            Scanner scanner = new Scanner(new URL(url).openStream(), StandardCharsets.UTF_8.toString());
            try {
                String lastName;
                String firstName;
                scanner.useDelimiter("\\A");
                if (scanner.hasNext()) {
                    JsonObject json = new JsonParser().parse(scanner.next()).getAsJsonObject();
                    firstName = json.get("first_name").getAsString();
                    lastName = json.get("last_name").getAsString();
                } else {
                    firstName = "";
                    lastName = "";
                }
                UserProfile result = new UserProfile(firstName, lastName);
                this.userProfCache.put(userId, result);
                userProfile = result;
                scanner.close();
            }
            catch (Throwable firstName) {
                try {
                    try {
                        scanner.close();
                    }
                    catch (Throwable throwable) {
                        firstName.addSuppressed(throwable);
                    }
                    throw firstName;
                }
                catch (Exception e) {
                    UserProfile result = new UserProfile("", "");
                    this.userProfCache.put(userId, result);
                    return result;
                }
            }
            return userProfile;
        }
    }

    @RequestMapping(method={RequestMethod.POST})
    public ResponseEntity<Void> handleCallback(@RequestBody String payload, @RequestHeader(value="X-Hub-Signature") String signature) {
        this.LOGGER.fine(() -> String.format("Received Facebook callback - payload: %s | signature: %s", payload, signature));
        try {
            JsonParser parser = new JsonParser();
            JsonObject castedPayload = parser.parse(payload).getAsJsonObject();
            String senderId = castedPayload.get("entry").getAsJsonArray().get(0).getAsJsonObject().get("messaging").getAsJsonArray().get(0).getAsJsonObject().get("sender").getAsJsonObject().get("id").getAsString();
            UserProfile user = this.queryUserProfile(senderId);
            this.messenger.onReceiveEvents(payload, Optional.of(signature), event -> {
                this.facebookMessenger.sendTypingOn(event.senderId());
                if (event.isQuickReplyMessageEvent()) {
                    this.handleQuickReplyMessageEvent(event.asQuickReplyMessageEvent(), user);
                } else if (event.isPostbackEvent()) {
                    this.handlePostbackEvent(event.asPostbackEvent(), user);
                } else if (event.isTextMessageEvent()) {
                    this.handleTextMessageEvent(event.asTextMessageEvent(), user);
                } else if (event.isAttachmentMessageEvent()) {
                    this.handleAttachmentEvent(event.asAttachmentMessageEvent(), user);
                }
            });
            this.LOGGER.fine(() -> "Processed Facebook callback payload successfully");
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).build();
        }
        catch (Exception e) {
            this.LOGGER.severe(() -> String.format("Processing of Facebook callback payload failed: %s", e.getMessage()));
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).build();
        }
    }

    private void handlePostbackEvent(PostbackEvent event, UserProfile user) {
        this.LOGGER.fine(() -> String.format("Received PostbackEvent: %s", event));
        String senderId = event.senderId();
        Instant timestamp = event.timestamp();
        this.LOGGER.info(() -> String.format("Received Facebook post back from user '%s' at '%s'", senderId, timestamp));
        if (event.payload().isPresent()) {
            this.assistant.handleTextMessage(event.senderId(), (String)event.payload().get(), this.facebookMessenger, user);
        }
    }

    private void handleQuickReplyMessageEvent(QuickReplyMessageEvent event, UserProfile user) {
        this.LOGGER.fine(() -> String.format("Received QuickReplyMessageEvent: %s", event));
        String messageId = event.messageId();
        String messageText = event.text();
        String senderId = event.senderId();
        Instant timestamp = event.timestamp();
        this.LOGGER.info(() -> String.format("Received Facebook quick reply '%s' with text '%s' from user '%s' at '%s'", messageId, messageText, senderId, timestamp));
        this.assistant.handleTextMessage(event.senderId(), event.payload(), this.facebookMessenger, user);
    }

    private void handleTextMessageEvent(TextMessageEvent event, UserProfile user) {
        this.LOGGER.fine(() -> String.format("Received TextMessageEvent: %s", event));
        String messageId = event.messageId();
        String messageText = event.text();
        String senderId = event.senderId();
        Instant timestamp = event.timestamp();
        this.LOGGER.info(() -> String.format("Received Facebook message '%s' with text '%s' from user '%s' at '%s'", messageId, messageText, senderId, timestamp));
        this.assistant.handleTextMessage(event.senderId(), event.text(), this.facebookMessenger, user);
    }

    private void handleAttachmentEvent(AttachmentMessageEvent event, UserProfile user) {
        this.LOGGER.fine(() -> String.format("Received AttachmentMessageEvent: %s", event));
        String messageId = event.messageId();
        String senderId = event.senderId();
        Instant timestamp = event.timestamp();
        String messageText = "";
        if (event.attachments().size() > 0) {
            Attachment attachment = (Attachment)event.attachments().get(0);
            if (attachment.asRichMediaAttachment().type().equals((Object)RichMediaAttachment.Type.IMAGE)) {
                messageText = "++user_input:PHOTO++";
                if (attachment.asRichMediaAttachment().url().toString().toLowerCase().contains("&oe=5d7d2175")) {
                    messageText = "++user_input:THUMB_UP++";
                }
            } else if (attachment.asRichMediaAttachment().type().equals((Object)RichMediaAttachment.Type.AUDIO)) {
                messageText = "++user_input:AUDIO++";
            } else if (attachment.asRichMediaAttachment().type().equals((Object)RichMediaAttachment.Type.FILE)) {
                messageText = "++user_input:DOCUMENT++";
            }
            String messageFinal = messageText;
            this.LOGGER.info(() -> String.format("Received Facebook message '%s' with text '%s' from user '%s' at '%s'", messageId, messageFinal, senderId, timestamp));
            this.assistant.handleTextMessage(event.senderId(), messageText, this.facebookMessenger, user);
        }
    }
}

