/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.testutils.llm;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.github.difflib.DiffUtils;
import com.github.difflib.UnifiedDiffUtils;
import com.github.difflib.patch.Patch;
import com.theokanning.openai.completion.chat.ChatCompletionChoice;
import com.theokanning.openai.completion.chat.ChatCompletionRequest;
import com.theokanning.openai.completion.chat.ChatFunction;
import com.theokanning.openai.completion.chat.ChatMessage;
import com.theokanning.openai.completion.chat.ChatMessageRole;
import com.theokanning.openai.service.FunctionExecutor;
import io.codemodder.EncodingDetector;
import io.codemodder.plugins.llm.OpenAIService;
import io.codemodder.testutils.CodemodTestMixin;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;

public interface LLMVerifyingCodemodTestMixin
extends CodemodTestMixin {
    public static final String SYSTEM_MESSAGE_TEMPLATE = "You are a software engineer bot. You are helping assess a Java coding assignment given to an interviewee.\n\nThe interviewee was given code and asked to modify it to meet these requirements:\n%s\n\nA PASS example:\n```diff\n%s\n```\n\nYou will be given the interviewee's solution in unified diff format. Analyze the changes line-by-line, compare them to the PASS example, and assess whether they PASS or FAIL the assignment. If the changes have any syntax errors or are made in a block of code that does not meet the requirements, they automatically FAIL.\n";
    public static final String USER_MESSAGE_TEMPLATE = "```diff\n%s\n```\n";

    public String getRequirementsPrompt();

    default public void verifyTransformedCode(Path before, Path expected, Path after) throws IOException {
        String transformedJavaCode;
        String expectedCode = Files.readString(expected, this.getCharset(expected));
        if (!expectedCode.equals(transformedJavaCode = Files.readString(after, this.getCharset(after)))) {
            Assessment assessment = this.assessChanges(before, after, expected);
            MatcherAssert.assertThat((String)assessment.getAnalysis(), (Object)((Object)assessment.getResult()), (Matcher)Matchers.is((Object)((Object)AssessmentResult.PASS)));
            System.out.println(assessment.getAnalysis());
        }
    }

    private Assessment assessChanges(Path before, Path actualAfter, Path expectedAfter) throws IOException {
        ChatFunction function = ChatFunction.builder().name("save_assessment").description("Saves an assessment.").executor(Assessment.class, c -> c).build();
        FunctionExecutor functionExecutor = new FunctionExecutor(Collections.singletonList(function));
        ChatCompletionRequest request = ChatCompletionRequest.builder().model("gpt-3.5-turbo-0613").messages(List.of(new ChatMessage(ChatMessageRole.SYSTEM.value(), SYSTEM_MESSAGE_TEMPLATE.formatted(this.getRequirementsPrompt().strip(), this.getUnifiedDiff(before, expectedAfter).strip()).strip()), new ChatMessage(ChatMessageRole.USER.value(), USER_MESSAGE_TEMPLATE.formatted(this.getUnifiedDiff(before, actualAfter).strip()).strip()))).functions(functionExecutor.getFunctions()).functionCall(ChatCompletionRequest.ChatCompletionRequestFunctionCall.of((String)function.getName())).temperature(Double.valueOf(0.0)).build();
        OpenAIService openAI = new OpenAIService(System.getenv("CODEMODDER_OPENAI_API_KEY"));
        ChatMessage response = ((ChatCompletionChoice)openAI.createChatCompletion(request).getChoices().get(0)).getMessage();
        return (Assessment)functionExecutor.execute(response.getFunctionCall());
    }

    private String getUnifiedDiff(Path original, Path revised) throws IOException {
        return String.join((CharSequence)"\n", UnifiedDiffUtils.generateUnifiedDiff((String)original.getFileName().toString(), (String)original.getFileName().toString(), this.readAllLines(original), this.diff(original, revised), (int)5)) + "\n";
    }

    private Patch<String> diff(Path original, Path revised) throws IOException {
        return DiffUtils.diff(this.readAllLines(original), this.readAllLines(revised));
    }

    private List<String> readAllLines(Path path) throws IOException {
        return List.of(Files.readString(path, this.getCharset(path)).split("\\R", -1));
    }

    private Charset getCharset(Path path) throws IOException {
        return Charset.forName(EncodingDetector.create().detect(path).orElse("UTF-8"));
    }

    public static final class Assessment {
        @JsonPropertyDescription(value="A detailed analysis of how the candidate's solution was assessed.")
        @JsonProperty(required=true)
        private String analysis;
        @JsonPropertyDescription(value="The result of the assessment, either PASS or FAIL.")
        @JsonProperty(required=true)
        private AssessmentResult result;

        public String getAnalysis() {
            return this.analysis;
        }

        public AssessmentResult getResult() {
            return this.result;
        }
    }

    public static enum AssessmentResult {
        PASS,
        FAIL;

    }
}

