/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.providers.sarif.semgrep;

import com.contrastsecurity.sarif.Location;
import com.contrastsecurity.sarif.Region;
import com.contrastsecurity.sarif.Result;
import com.contrastsecurity.sarif.Run;
import com.contrastsecurity.sarif.SarifSchema210;
import io.codemodder.RuleSarif;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

final class SingleSemgrepRuleSarif
implements RuleSarif {
    private final SarifSchema210 sarif;
    private final String ruleId;
    private final Map<Path, List<Result>> resultsCache;
    private final Path repositoryRoot;
    static final String toolName = "semgrep";

    SingleSemgrepRuleSarif(String ruleId, SarifSchema210 sarif, Path repositoryRoot) {
        this.sarif = Objects.requireNonNull(sarif);
        this.ruleId = Objects.requireNonNull(ruleId);
        this.repositoryRoot = Objects.requireNonNull(repositoryRoot);
        this.resultsCache = new HashMap<Path, List<Result>>();
    }

    public SarifSchema210 rawDocument() {
        return this.sarif;
    }

    public String getRule() {
        return this.ruleId;
    }

    public List<Region> getRegionsFromResultsByRule(Path path) {
        return this.getResultsByLocationPath(path).stream().map(result -> ((Location)result.getLocations().get(0)).getPhysicalLocation().getRegion()).toList();
    }

    public List<Result> getResultsByLocationPath(Path path) {
        if (this.resultsCache.containsKey(path)) {
            return this.resultsCache.get(path);
        }
        List<Result> results = ((Run)this.sarif.getRuns().get(0)).getResults().stream().filter(result -> result.getRuleId().endsWith("." + this.ruleId) || result.getRuleId().equals(this.ruleId)).filter(result -> {
            String uri = ((Location)result.getLocations().get(0)).getPhysicalLocation().getArtifactLocation().getUri();
            try {
                return Files.isSameFile(path, this.repositoryRoot.resolve(uri));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }).toList();
        this.resultsCache.put(path, results);
        return results;
    }

    public String getDriver() {
        return toolName;
    }
}

