/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.remediation.xxe;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.expr.BooleanLiteralExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.Statement;
import io.codemodder.ast.ASTs;
import io.codemodder.remediation.SuccessOrReason;
import java.util.List;
import java.util.Optional;

public class XMLFixBuilder {
    static MethodCallExpr createParameterEntityDisabledCall(NameExpr nameExpr) {
        return new MethodCallExpr((Expression)nameExpr, "setFeature", NodeList.nodeList((Node[])new Expression[]{new StringLiteralExpr("http://xml.org/sax/features/external-parameter-entities"), new BooleanLiteralExpr(false)}));
    }

    static MethodCallExpr createGeneralEntityDisablingCall(NameExpr nameExpr) {
        return new MethodCallExpr((Expression)nameExpr, "setFeature", NodeList.nodeList((Node[])new Expression[]{new StringLiteralExpr("http://xml.org/sax/features/external-general-entities"), new BooleanLiteralExpr(false)}));
    }

    static SuccessOrReason addXMLInputFactoryDisablingStatement(NameExpr variable, Statement statementToInjectAround, boolean before) {
        MethodCallExpr call = new MethodCallExpr((Expression)variable, "setProperty", NodeList.nodeList((Node[])new Expression[]{new StringLiteralExpr("javax.xml.stream.isSupportingExternalEntities"), new BooleanLiteralExpr(false)}));
        Optional<BlockStmt> block = ASTs.findBlockStatementFrom((Node)statementToInjectAround);
        if (block.isEmpty()) {
            return SuccessOrReason.reason("No block statement found for newFactory() call");
        }
        BlockStmt blockStmt = block.get();
        NodeList existingStatements = blockStmt.getStatements();
        int index = existingStatements.indexOf((Object)statementToInjectAround);
        if (!before) {
            ++index;
        }
        ExpressionStmt fixStatement = new ExpressionStmt((Expression)call);
        existingStatements.add(index, (Node)fixStatement);
        return SuccessOrReason.success();
    }

    static SuccessOrReason addFeatureDisablingStatements(NameExpr variable, Statement statementToInjectAround, boolean before) {
        Optional<BlockStmt> block = ASTs.findBlockStatementFrom((Node)statementToInjectAround);
        if (block.isEmpty()) {
            return SuccessOrReason.reason("No block statement found for newFactory() call");
        }
        BlockStmt blockStmt = block.get();
        MethodCallExpr setFeatureGeneralEntities = XMLFixBuilder.createGeneralEntityDisablingCall(variable);
        MethodCallExpr setFeatureParameterEntities = XMLFixBuilder.createParameterEntityDisabledCall(variable);
        List<ExpressionStmt> fixStatements = List.of(new ExpressionStmt((Expression)setFeatureGeneralEntities), new ExpressionStmt((Expression)setFeatureParameterEntities));
        NodeList existingStatements = blockStmt.getStatements();
        int index = existingStatements.indexOf((Object)statementToInjectAround);
        if (!before) {
            ++index;
        }
        existingStatements.addAll(index, fixStatements);
        blockStmt.findAll(MethodCallExpr.class).stream().filter(m -> "setExpandEntityReferences".equals(m.getNameAsString()) && m.getScope().isPresent() && ((Expression)m.getScope().get()).equals((Object)variable) && m.getArguments().size() == 1 && ((Expression)m.getArguments().get(0)).isBooleanLiteralExpr() && ((Expression)m.getArguments().get(0)).asBooleanLiteralExpr().getValue()).map(Node::getParentNode).filter(Optional::isPresent).map(Optional::get).forEach(Node::remove);
        return SuccessOrReason.success();
    }
}

