/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.remediation.xxe;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.FieldAccessExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.Statement;
import io.codemodder.ast.ASTTransforms;
import io.codemodder.ast.ASTs;
import io.codemodder.javaparser.ASTExpectations;
import io.codemodder.remediation.MatchAndFixStrategy;
import io.codemodder.remediation.SuccessOrReason;
import java.util.List;
import java.util.Optional;

final class TransformerFactoryAtCreationFixStrategy
extends MatchAndFixStrategy {
    TransformerFactoryAtCreationFixStrategy() {
    }

    @Override
    public SuccessOrReason fix(CompilationUnit cu, Node node) {
        Optional<MethodCallExpr> maybeCall = Optional.of(node).map(n -> n instanceof MethodCallExpr ? (MethodCallExpr)n : null);
        if (maybeCall.isEmpty()) {
            return SuccessOrReason.reason("Not a method call.");
        }
        MethodCallExpr newFactoryInstanceCall = maybeCall.get();
        Optional<VariableDeclarator> newFactoryVariableRef = ASTExpectations.expect((Node)newFactoryInstanceCall).toBeMethodCallExpression().initializingVariable().result();
        VariableDeclarator newFactoryVariable = newFactoryVariableRef.get();
        Optional variableDeclarationStmtRef = newFactoryVariable.findAncestor(new Class[]{Statement.class});
        if (variableDeclarationStmtRef.isEmpty()) {
            return SuccessOrReason.reason("Not assigned as part of statement");
        }
        Statement statement = (Statement)variableDeclarationStmtRef.get();
        Optional<BlockStmt> block = ASTs.findBlockStatementFrom((Node)statement);
        if (block.isEmpty()) {
            return SuccessOrReason.reason("No block statement found for newFactory() call");
        }
        BlockStmt blockStmt = block.get();
        MethodCallExpr setAttributeCall = new MethodCallExpr((Expression)newFactoryVariable.getNameAsExpression(), "setAttribute", NodeList.nodeList((Node[])new Expression[]{new FieldAccessExpr((Expression)new NameExpr("XMLConstants"), "ACCESS_EXTERNAL_DTD"), new StringLiteralExpr("")}));
        ASTTransforms.addImportIfMissing(cu, "javax.xml.XMLConstants");
        ExpressionStmt fixStatement = new ExpressionStmt((Expression)setAttributeCall);
        NodeList existingStatements = blockStmt.getStatements();
        int index = existingStatements.indexOf((Object)statement);
        existingStatements.add(index + 1, (Node)fixStatement);
        return SuccessOrReason.success();
    }

    @Override
    public boolean match(Node node) {
        return ASTs.isInitializedToType(node, "newInstance", List.of("TransformerFactory")).isPresent();
    }
}

