/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.remediation.xxe;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.stmt.Statement;
import io.codemodder.ast.ASTs;
import io.codemodder.javaparser.ASTExpectations;
import io.codemodder.remediation.MatchAndFixStrategy;
import io.codemodder.remediation.SuccessOrReason;
import io.codemodder.remediation.xxe.XMLFixBuilder;
import java.util.List;
import java.util.Optional;

final class DocumentBuilderFactoryAndSAXParserAtCreationFixStrategy
extends MatchAndFixStrategy {
    DocumentBuilderFactoryAndSAXParserAtCreationFixStrategy() {
    }

    @Override
    public SuccessOrReason fix(CompilationUnit cu, Node node) {
        Optional<MethodCallExpr> maybeCall = Optional.of(node).map(m -> m instanceof MethodCallExpr ? (MethodCallExpr)node : null);
        if (maybeCall.isEmpty()) {
            return SuccessOrReason.reason("Not a method call");
        }
        MethodCallExpr newFactoryInstanceCall = maybeCall.get();
        Optional<VariableDeclarator> newFactoryVariableRef = ASTExpectations.expect((Node)newFactoryInstanceCall).toBeMethodCallExpression().initializingVariable().result();
        VariableDeclarator newFactoryVariable = newFactoryVariableRef.get();
        Optional variableDeclarationStmtRef = newFactoryVariable.findAncestor(new Class[]{Statement.class});
        if (variableDeclarationStmtRef.isEmpty()) {
            SuccessOrReason.reason("Not assigned as part of statement");
        }
        Statement statement = (Statement)variableDeclarationStmtRef.get();
        return XMLFixBuilder.addFeatureDisablingStatements(newFactoryVariable.getNameAsExpression(), statement, false);
    }

    @Override
    public boolean match(Node node) {
        return ASTs.isInitializedToType(node, "newInstance", List.of("DocumentBuilderFactory", "SAXParserFactory")).isPresent();
    }
}

