/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.remediation.weakrandom;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import io.codemodder.DependencyGAV;
import io.codemodder.ast.ASTTransforms;
import io.codemodder.remediation.RemediationStrategy;
import io.codemodder.remediation.SuccessOrReason;
import java.security.SecureRandom;
import java.util.List;
import java.util.Optional;

final class WeakRandomFixStrategy
implements RemediationStrategy {
    WeakRandomFixStrategy() {
    }

    @Override
    public SuccessOrReason fix(CompilationUnit cu, Node node) {
        Optional<ObjectCreationExpr> maybeOCE = Optional.of(node).map(n -> n instanceof ObjectCreationExpr ? (ObjectCreationExpr)n : null);
        if (maybeOCE.isEmpty()) {
            return SuccessOrReason.reason("Not an object creation expression");
        }
        ObjectCreationExpr unsafeRandom = maybeOCE.get();
        unsafeRandom.setType("SecureRandom");
        ASTTransforms.addImportIfMissing(cu, SecureRandom.class.getName());
        return SuccessOrReason.success(List.of(DependencyGAV.JAVA_SECURITY_TOOLKIT));
    }
}

