/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.remediation.sqlinjection;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.CallableDeclaration;
import com.github.javaparser.ast.expr.MethodCallExpr;
import io.codemodder.ast.ASTTransforms;
import io.codemodder.remediation.sqlinjection.SQLParameterizer;
import java.util.Optional;

public final class SQLParameterizerWithCleanup {
    private SQLParameterizerWithCleanup() {
    }

    public static boolean checkAndFix(MethodCallExpr methodCallExpr) {
        Optional<MethodCallExpr> maybeFixed = new SQLParameterizer(methodCallExpr).checkAndFix();
        maybeFixed.ifPresent(call -> SQLParameterizerWithCleanup.cleanup(call));
        return maybeFixed.isPresent();
    }

    public static void cleanup(MethodCallExpr pstmtCall) {
        Optional maybeMethodDecl = pstmtCall.findAncestor(new Class[]{CallableDeclaration.class});
        maybeMethodDecl.ifPresent(ASTTransforms::removeEmptyStringConcatenation);
        maybeMethodDecl.ifPresent(md -> ASTTransforms.removeUnusedLocalVariables((Node)md));
        pstmtCall.getArguments().getFirst().ifPresent(ASTTransforms::mergeConcatenatedLiterals);
    }
}

