/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.remediation.reflectioninjection;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import io.codemodder.DependencyGAV;
import io.codemodder.ast.ASTTransforms;
import io.codemodder.remediation.RemediationStrategy;
import io.codemodder.remediation.SuccessOrReason;
import io.github.pixee.security.Reflection;
import java.util.List;
import java.util.Optional;

public final class ReflectionInjectionFixStrategy
implements RemediationStrategy {
    @Override
    public SuccessOrReason fix(CompilationUnit cu, Node node) {
        Optional<MethodCallExpr> maybeCall = Optional.of(node).map(n -> n instanceof MethodCallExpr ? (MethodCallExpr)n : null);
        if (maybeCall.isEmpty()) {
            return SuccessOrReason.reason("Not a method call");
        }
        MethodCallExpr methodCallExpr = maybeCall.get();
        ReflectionInjectionFixStrategy.replaceMethodCallExpression(cu, methodCallExpr);
        return SuccessOrReason.success(List.of(DependencyGAV.JAVA_SECURITY_TOOLKIT));
    }

    private static void replaceMethodCallExpression(CompilationUnit cu, MethodCallExpr methodCallExpr) {
        NameExpr name = new NameExpr(Reflection.class.getSimpleName());
        methodCallExpr.setScope((Expression)name);
        methodCallExpr.setName("loadAndVerify");
        ASTTransforms.addImportIfMissing(cu, Reflection.class);
    }
}

