/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.remediation.predictableseed;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.LiteralExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import io.codemodder.CodemodFileScanningResult;
import io.codemodder.codetf.DetectorRule;
import io.codemodder.remediation.FixCandidateSearcher;
import io.codemodder.remediation.MethodOrConstructor;
import io.codemodder.remediation.RemediationStrategy;
import io.codemodder.remediation.Remediator;
import io.codemodder.remediation.SearcherStrategyRemediator;
import io.codemodder.remediation.SuccessOrReason;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Function;

public final class PredictableSeedRemediator<T>
implements Remediator<T> {
    private final SearcherStrategyRemediator<T> searchStrategyRemediator = new SearcherStrategyRemediator.Builder().withSearcherStrategyPair(new FixCandidateSearcher.Builder().withMatcher(n -> Optional.of(n).map(MethodOrConstructor::new).filter(mce -> mce.isMethodCallWithName("setSeed")).filter(mce -> mce.asNode().hasScope()).filter(mce -> mce.getArguments().size() == 1).filter(mce -> !(mce.getArguments().get(0) instanceof LiteralExpr)).isPresent()).build(), new RemediationStrategy(){

        @Override
        public SuccessOrReason fix(CompilationUnit cu, Node node) {
            MethodCallExpr setSeedCall = (MethodCallExpr)node;
            MethodCallExpr safeExpression = new MethodCallExpr((Expression)new NameExpr(System.class.getSimpleName()), "currentTimeMillis");
            NodeList arguments = setSeedCall.getArguments();
            arguments.set(0, (Node)safeExpression);
            return SuccessOrReason.success();
        }
    }).build();

    @Override
    public CodemodFileScanningResult remediateAll(CompilationUnit cu, String path, DetectorRule detectorRule, Collection<T> findingsForPath, Function<T, String> findingIdExtractor, Function<T, Integer> findingStartLineExtractor, Function<T, Optional<Integer>> findingEndLineExtractor, Function<T, Optional<Integer>> findingColumnExtractor) {
        return this.searchStrategyRemediator.remediateAll(cu, path, detectorRule, findingsForPath, findingIdExtractor, findingStartLineExtractor, findingEndLineExtractor, findingColumnExtractor);
    }
}

