/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.remediation.missingsecureflag;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.BooleanLiteralExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.nodeTypes.NodeWithSimpleName;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.Statement;
import io.codemodder.ast.ASTTransforms;
import io.codemodder.ast.ASTs;
import io.codemodder.remediation.RemediationStrategy;
import io.codemodder.remediation.SuccessOrReason;
import java.util.Optional;

final class FixAtJakartaCookieCreationStrategy
implements RemediationStrategy {
    FixAtJakartaCookieCreationStrategy() {
    }

    @Override
    public SuccessOrReason fix(CompilationUnit cu, Node node) {
        Optional<ObjectCreationExpr> cookieCreationExpression = Optional.of(node).map(n -> n instanceof ObjectCreationExpr ? (ObjectCreationExpr)n : null);
        if (cookieCreationExpression.isPresent()) {
            Optional<Statement> maybeStmt = ASTs.findParentStatementFrom((Node)cookieCreationExpression.get()).filter(Statement::isExpressionStmt);
            if (maybeStmt.isEmpty()) {
                return SuccessOrReason.reason("Could not find expression statement containing call");
            }
            Optional<NameExpr> maybeCookieName = cookieCreationExpression.get().getParentNode().map(vd -> vd instanceof VariableDeclarator ? (VariableDeclarator)vd : null).map(NodeWithSimpleName::getNameAsExpression);
            if (maybeCookieName.isEmpty()) {
                return SuccessOrReason.reason("Could not find variable declaration expression");
            }
            ExpressionStmt newStatement = new ExpressionStmt((Expression)new MethodCallExpr((Expression)maybeCookieName.get(), "setSecure", new NodeList((Node[])new Expression[]{new BooleanLiteralExpr(true)})));
            ASTTransforms.addStatementAfterStatement(maybeStmt.get(), (Statement)newStatement);
            return SuccessOrReason.success();
        }
        return SuccessOrReason.reason("Not a method call with scope.");
    }
}

