/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.remediation.jndiinjection;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.expr.NameExpr;
import io.codemodder.CodemodFileScanningResult;
import io.codemodder.codetf.DetectorRule;
import io.codemodder.remediation.FixCandidateSearcher;
import io.codemodder.remediation.MethodOrConstructor;
import io.codemodder.remediation.RemediationStrategy;
import io.codemodder.remediation.Remediator;
import io.codemodder.remediation.SearcherStrategyRemediator;
import io.codemodder.remediation.jndiinjection.ReplaceLimitedLookupStrategy;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Function;

public final class JNDIInjectionRemediator<T>
implements Remediator<T> {
    private final SearcherStrategyRemediator<T> searchStrategyRemediator;

    public JNDIInjectionRemediator() {
        this(new ReplaceLimitedLookupStrategy());
    }

    public JNDIInjectionRemediator(RemediationStrategy strategy) {
        this.searchStrategyRemediator = new SearcherStrategyRemediator.Builder().withSearcherStrategyPair(new FixCandidateSearcher.Builder().withMatcher(n -> Optional.of(n).map(MethodOrConstructor::new).filter(mce -> mce.isMethodCallWithName("lookup")).filter(mce -> mce.asNode().hasScope()).filter(mce -> mce.getArguments().size() == 1).filter(mce -> mce.getArguments().get(0) instanceof NameExpr).isPresent()).build(), strategy).build();
    }

    @Override
    public CodemodFileScanningResult remediateAll(CompilationUnit cu, String path, DetectorRule detectorRule, Collection<T> findingsForPath, Function<T, String> findingIdExtractor, Function<T, Integer> findingStartLineExtractor, Function<T, Optional<Integer>> findingEndLineExtractor, Function<T, Optional<Integer>> findingStartColumnExtractor) {
        return this.searchStrategyRemediator.remediateAll(cu, path, detectorRule, findingsForPath, findingIdExtractor, findingStartLineExtractor, findingEndLineExtractor, findingStartColumnExtractor);
    }
}

