/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.remediation.jndiinjection;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.Statement;
import io.codemodder.Either;
import java.util.Optional;

record JNDIFixContext(MethodCallExpr lookupCall, ClassOrInterfaceDeclaration parentClass, NameExpr contextNameVariable, BlockStmt blockStmt, Integer index) {
    static Either<JNDIFixContext, String> fromNode(Node node) {
        Optional<MethodCallExpr> maybeLookupCall = Optional.of(node).map(n -> n instanceof MethodCallExpr ? (MethodCallExpr)n : null);
        if (maybeLookupCall.isEmpty()) {
            return Either.right("Node is not a method call");
        }
        MethodCallExpr lookupCall = maybeLookupCall.get();
        Optional maybeParentMethod = lookupCall.findAncestor(new Class[]{MethodDeclaration.class});
        if (maybeParentMethod.isEmpty()) {
            return Either.right("No method found around lookup call");
        }
        MethodDeclaration parentMethod = (MethodDeclaration)maybeParentMethod.get();
        Optional maybeParentClass = parentMethod.findAncestor(new Class[]{ClassOrInterfaceDeclaration.class});
        if (maybeParentClass.filter(c -> c.isInterface()).isPresent()) {
            return Either.right("Cannot add validation method to interface");
        }
        ClassOrInterfaceDeclaration parentClass = (ClassOrInterfaceDeclaration)maybeParentClass.get();
        Optional maybeLookupStatement = lookupCall.findAncestor(new Class[]{Statement.class});
        if (maybeLookupStatement.isEmpty()) {
            return Either.right("No statement found around lookup call");
        }
        Statement lookupStatement = (Statement)maybeLookupStatement.get();
        Optional<NameExpr> maybeContextNameVariable = lookupCall.getArguments().stream().findFirst().map(arg -> arg.isNameExpr() ? arg.asNameExpr() : null);
        if (maybeContextNameVariable.isEmpty()) {
            return Either.right("No context name variable found for the first argument");
        }
        NameExpr contextNameVariable = maybeContextNameVariable.get();
        Optional lookupParentNode = lookupStatement.getParentNode();
        if (lookupParentNode.isEmpty()) {
            return Either.right("No parent node found around lookup call");
        }
        Object t = lookupParentNode.get();
        if (!(t instanceof BlockStmt)) {
            return Either.right("No block statement found around lookup call");
        }
        BlockStmt blockStmt = (BlockStmt)t;
        int index = blockStmt.getStatements().indexOf((Object)lookupStatement);
        return Either.left(new JNDIFixContext(lookupCall, parentClass, contextNameVariable, blockStmt, index));
    }
}

