/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.remediation.jndiinjection;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import io.codemodder.Either;
import io.codemodder.ast.ASTTransforms;
import io.codemodder.remediation.RemediationStrategy;
import io.codemodder.remediation.SuccessOrReason;
import io.codemodder.remediation.jndiinjection.JNDIFixContext;
import java.util.Set;

final class InjectValidationMethodStrategy
implements RemediationStrategy {
    private final MethodDeclaration fixMethod;
    private static final String validateResourceMethodName = "validateResourceName";

    InjectValidationMethodStrategy() {
        String fixMethodCode = "private static void validateResourceName(final String name) {\n    if (name != null) {\n      Set<String> illegalNames = Set.of(\"ldap://\", \"rmi://\", \"dns://\", \"java:\");\n      String canonicalName = name.toLowerCase().trim();\n      if (illegalNames.stream().anyMatch(canonicalName::startsWith)) {\n        throw new SecurityException(\"Illegal JNDI resource name: \" + name);\n      }\n    }\n}\n";
        this.fixMethod = StaticJavaParser.parseMethodDeclaration((String)fixMethodCode);
    }

    @Override
    public SuccessOrReason fix(CompilationUnit cu, Node node) {
        Either<JNDIFixContext, String> contextOrReason = JNDIFixContext.fromNode(node);
        if (contextOrReason.isRight()) {
            return SuccessOrReason.reason(contextOrReason.getRight());
        }
        JNDIFixContext context = contextOrReason.getLeft();
        MethodCallExpr validationCall = new MethodCallExpr(null, validateResourceMethodName);
        validationCall.addArgument((Expression)context.contextNameVariable());
        context.blockStmt().addStatement(context.index().intValue(), (Expression)validationCall);
        boolean alreadyHasResourceValidationCallPresent = context.parentClass().findAll(MethodDeclaration.class).stream().anyMatch(md -> md.getNameAsString().equals(validateResourceMethodName) && md.getParameters().size() == 1 && ((Parameter)md.getParameters().get(0)).getTypeAsString().equals("String"));
        if (!alreadyHasResourceValidationCallPresent) {
            context.parentClass().addMember((BodyDeclaration)this.fixMethod);
            ASTTransforms.addImportIfMissing(cu, Set.class);
        }
        return SuccessOrReason.success();
    }
}

