/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.remediation.javadeserialization;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.expr.VariableDeclarationExpr;
import io.codemodder.DependencyGAV;
import io.codemodder.Either;
import io.codemodder.ast.ASTs;
import io.codemodder.ast.LocalDeclaration;
import io.codemodder.javaparser.JavaParserTransformer;
import io.codemodder.remediation.RemediationStrategy;
import io.codemodder.remediation.SuccessOrReason;
import io.github.pixee.security.ObjectInputFilters;
import java.util.List;
import java.util.Optional;

public final class JavaDeserializationFixStrategy
implements RemediationStrategy {
    private Either<ObjectCreationExpr, String> findConstructor(MethodCallExpr call) {
        Optional<NameExpr> maybeCallScope = call.getScope().map(s -> s instanceof NameExpr ? s.asNameExpr() : null);
        if (maybeCallScope.isEmpty()) {
            return Either.right("Unexpected shape");
        }
        NameExpr callScope = maybeCallScope.get();
        Optional<LocalDeclaration> declaration = ASTs.findEarliestLocalDeclarationOf(callScope.getName());
        if (declaration.isEmpty()) {
            return Either.right("No declaration found");
        }
        LocalDeclaration localDeclaration = declaration.get();
        Node varDeclarationAndExpr = localDeclaration.getDeclaration();
        if (varDeclarationAndExpr instanceof VariableDeclarator) {
            VariableDeclarator varDec = (VariableDeclarator)varDeclarationAndExpr;
            Optional initializer = varDec.getInitializer();
            if (initializer.isEmpty()) {
                return Either.right("No initializer found");
            }
            Expression expression = (Expression)initializer.get();
            if (expression instanceof ObjectCreationExpr) {
                ObjectCreationExpr objCreation = (ObjectCreationExpr)expression;
                return Either.left(objCreation);
            }
        } else {
            return Either.right("Unexpected declaration type");
        }
        return Either.right("Failed to find constructor for associated call");
    }

    @Override
    public SuccessOrReason fix(CompilationUnit cu, Node node) {
        Node node2;
        if (node instanceof VariableDeclarationExpr) {
            VariableDeclarationExpr vd = (VariableDeclarationExpr)node;
            node2 = ((Expression)vd.getVariable(0).getInitializer().get()).asObjectCreationExpr();
        } else {
            node2 = node;
        }
        Node consideredNode = node2;
        Optional maybeCallOrConstructor = Optional.empty().or(() -> consideredNode instanceof MethodCallExpr ? Optional.of(Either.left((MethodCallExpr)consideredNode)) : Optional.empty()).or(() -> consideredNode instanceof ObjectCreationExpr ? Optional.of(Either.right((ObjectCreationExpr)consideredNode)) : Optional.empty());
        if (maybeCallOrConstructor.isEmpty()) {
            return SuccessOrReason.reason("Not a call or constructor");
        }
        Either maybeConstructor = ((Either)maybeCallOrConstructor.get()).ifLeftOrElseGet(this::findConstructor, Either::left);
        if (maybeConstructor.isRight()) {
            return SuccessOrReason.reason((String)maybeConstructor.getRight());
        }
        this.fixObjectInputStreamCreation((ObjectCreationExpr)maybeConstructor.getLeft());
        return SuccessOrReason.success(List.of(DependencyGAV.JAVA_SECURITY_TOOLKIT));
    }

    private void fixObjectInputStreamCreation(ObjectCreationExpr objCreation) {
        JavaParserTransformer.replace((Expression)objCreation).withStaticMethod(ObjectInputFilters.class.getName(), "createSafeObjectInputStream").withStaticImport().withSameArguments();
    }

    public static boolean match(VariableDeclarationExpr node) {
        return Optional.of(node).flatMap(vde -> vde.getVariables().getFirst()).flatMap(VariableDeclarator::getInitializer).map(e -> e.isObjectCreationExpr() ? e.asObjectCreationExpr() : null).filter(JavaDeserializationFixStrategy::match).isPresent();
    }

    public static boolean match(ObjectCreationExpr node) {
        return Optional.of(node).map(n -> n instanceof ObjectCreationExpr ? n : null).filter(oce -> "ObjectInputStream".equals(oce.getTypeAsString())).isPresent();
    }

    public static boolean match(MethodCallExpr node) {
        return Optional.of(node).map(n -> n instanceof MethodCallExpr ? n : null).filter(mce -> mce.getNameAsString().equals("readObject")).filter(mce -> mce.getArguments().isEmpty()).isPresent();
    }

    public static boolean match(Node node) {
        if (node instanceof MethodCallExpr) {
            MethodCallExpr mce = (MethodCallExpr)node;
            return JavaDeserializationFixStrategy.match(mce);
        }
        if (node instanceof ObjectCreationExpr) {
            ObjectCreationExpr oce = (ObjectCreationExpr)node;
            return JavaDeserializationFixStrategy.match(oce);
        }
        return false;
    }
}

