/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.remediation.headerinjection;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import io.codemodder.javaparser.JavaParserTransformer;
import io.codemodder.remediation.RemediationStrategy;
import io.codemodder.remediation.SuccessOrReason;
import java.util.Optional;
import java.util.Set;

abstract class BaseHeaderInjectionFixStrategy
implements RemediationStrategy {
    private static final String validatorMethodName = "stripNewlines";
    private static final String fixMethodCode = "private static String stripNewlines(final String s) {\n  return s.replaceAll(\"[\\n\\r]\", \"\");\n}\n";
    protected static final Set<String> setHeaderNames = Set.of("setHeader", "addHeader");

    protected BaseHeaderInjectionFixStrategy() {
    }

    protected SuccessOrReason fix(MethodCallExpr setHeaderCall, Expression headerValueArgument) {
        Optional maybeParentClass = setHeaderCall.findAncestor(new Class[]{ClassOrInterfaceDeclaration.class});
        if (maybeParentClass.isEmpty()) {
            return SuccessOrReason.reason("Could not find parent class");
        }
        ClassOrInterfaceDeclaration parentClass = (ClassOrInterfaceDeclaration)maybeParentClass.get();
        if (parentClass.isInterface()) {
            MethodCallExpr inlinedStripCall = new MethodCallExpr(headerValueArgument, "replaceAll", NodeList.nodeList((Node[])new Expression[]{new StringLiteralExpr("[\\n\\r]"), new StringLiteralExpr("")}));
            setHeaderCall.getArguments().set(1, (Node)inlinedStripCall);
        } else {
            JavaParserTransformer.wrap(headerValueArgument).withScopelessMethod(validatorMethodName);
            boolean alreadyHasResourceValidationCallPresent = BaseHeaderInjectionFixStrategy.isAlreadyHasResourceValidationCallPresent(parentClass);
            if (!alreadyHasResourceValidationCallPresent) {
                BaseHeaderInjectionFixStrategy.addValidationCall(parentClass);
            }
        }
        return SuccessOrReason.success();
    }

    private static boolean isAlreadyHasResourceValidationCallPresent(ClassOrInterfaceDeclaration parentClass) {
        return parentClass.findAll(MethodDeclaration.class).stream().anyMatch(md -> md.getNameAsString().equals(validatorMethodName) && md.getParameters().size() == 1 && ((Parameter)md.getParameters().get(0)).getTypeAsString().equals("String"));
    }

    private static void addValidationCall(ClassOrInterfaceDeclaration parentClass) {
        MethodDeclaration fixMethod = StaticJavaParser.parseMethodDeclaration((String)fixMethodCode);
        parentClass.addMember((BodyDeclaration)fixMethod);
    }
}

