/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.remediation.errorexposure;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.Statement;
import io.codemodder.ast.ASTs;
import io.codemodder.remediation.MatchAndFixStrategy;
import io.codemodder.remediation.SuccessOrReason;
import java.util.List;
import java.util.Optional;

final class ErrorMessageExposureFixStrategy
extends MatchAndFixStrategy {
    private static final List<String> printErrorMethods = List.of("printStackTrace");
    private static final List<String> printMethods = List.of("println", "print", "sendError");

    ErrorMessageExposureFixStrategy() {
    }

    @Override
    public boolean match(Node node) {
        return Optional.empty().or(() -> Optional.of(node).map(n -> n instanceof Expression ? (Expression)n : null).flatMap(ASTs::isArgumentOfMethodCall).filter(mce -> printMethods.contains(mce.getNameAsString()))).or(() -> Optional.of(node).map(n -> n instanceof Expression ? (Expression)n : null).flatMap(e -> e.toMethodCallExpr()).filter(mce -> printErrorMethods.contains(mce.getNameAsString()))).isPresent();
    }

    @Override
    public SuccessOrReason fix(CompilationUnit cu, Node node) {
        Optional<Statement> maybeStmt = Optional.empty().or(() -> Optional.of(node).map(n -> {
            Expression e;
            return n instanceof Expression ? (e = (Expression)n) : null;
        }).flatMap(ASTs::isArgumentOfMethodCall).filter(mce -> printMethods.contains(mce.getNameAsString()))).or(() -> Optional.of(node).map(n -> {
            Expression e;
            return n instanceof Expression ? (e = (Expression)n) : null;
        }).flatMap(Expression::toMethodCallExpr).filter(mce -> printErrorMethods.contains(mce.getNameAsString()))).flatMap(Node::getParentNode).map(p -> p instanceof ExpressionStmt ? (ExpressionStmt)p : null);
        if (maybeStmt.isPresent()) {
            maybeStmt.get().remove();
            return SuccessOrReason.success();
        }
        return SuccessOrReason.reason("The call is not a statement");
    }
}

