/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.remediation;

import com.github.javaparser.Range;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.nodeTypes.NodeWithArguments;
import java.util.Collection;
import java.util.Objects;

public record MethodOrConstructor(Node node) {
    public MethodOrConstructor {
        Objects.requireNonNull(node);
    }

    public Node asNode() {
        return this.node;
    }

    public Range getRange() {
        return (Range)this.asNode().getRange().orElseThrow();
    }

    public NodeWithArguments<?> asNodeWithArguments() {
        return (NodeWithArguments)this.node;
    }

    public NodeList<?> getArguments() {
        return this.asNodeWithArguments().getArguments();
    }

    public boolean isConstructor() {
        return this.node instanceof ObjectCreationExpr;
    }

    public boolean isMethodCall() {
        return this.node instanceof MethodCallExpr;
    }

    public boolean isMethodCallWithScope() {
        MethodCallExpr mce;
        Node node = this.node;
        return node instanceof MethodCallExpr && (mce = (MethodCallExpr)node).getScope().isPresent();
    }

    public boolean isConstructorForType(String type) {
        ObjectCreationExpr oce;
        Node node = this.node;
        return node instanceof ObjectCreationExpr && (oce = (ObjectCreationExpr)node).getTypeAsString().equals(type);
    }

    public boolean hasRange() {
        return this.asNode().getRange().isPresent();
    }

    public boolean isMethodCallWithName(String name) {
        return this.isMethodCall() && ((MethodCallExpr)this.node).getNameAsString().equals(name);
    }

    public boolean isMethodCallWithNameIn(Collection<String> names) {
        return this.isMethodCall() && names.contains(((MethodCallExpr)this.node).getNameAsString());
    }

    public MethodCallExpr asMethodCall() {
        if (this.isMethodCall()) {
            return (MethodCallExpr)this.node;
        }
        throw new IllegalStateException("Not a method call");
    }

    public ObjectCreationExpr asObjectCreationExpr() {
        if (this.isConstructor()) {
            return (ObjectCreationExpr)this.node;
        }
        throw new IllegalStateException("Not a constructor");
    }
}

