/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.javaparser;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.printer.lexicalpreservation.LexicalPreservingPrinter;
import io.codemodder.CodemodChange;
import io.codemodder.CodemodFileScanningResult;
import io.codemodder.CodemodInvocationContext;
import io.codemodder.CodemodRunner;
import io.codemodder.EncodingDetector;
import io.codemodder.IncludesExcludes;
import io.codemodder.javaparser.JavaParserChanger;
import io.codemodder.javaparser.JavaParserFacade;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.Objects;

public final class JavaParserCodemodRunner
implements CodemodRunner {
    private final JavaParserChanger javaParserChanger;
    private final JavaParserFacade parser;
    private final EncodingDetector encodingDetector;
    private final IncludesExcludes rootedFileMatcher;

    public JavaParserCodemodRunner(JavaParserFacade parser, JavaParserChanger javaParserChanger, Path projectDir, IncludesExcludes globalIncludesExcludes, EncodingDetector encodingDetector) {
        this.parser = Objects.requireNonNull(parser);
        this.javaParserChanger = Objects.requireNonNull(javaParserChanger);
        this.encodingDetector = Objects.requireNonNull(encodingDetector);
        this.rootedFileMatcher = Objects.requireNonNull(globalIncludesExcludes);
    }

    public JavaParserCodemodRunner(JavaParserFacade parser, JavaParserChanger javaParserChanger, Path projectDir, EncodingDetector encodingDetector) {
        this.parser = Objects.requireNonNull(parser);
        this.javaParserChanger = Objects.requireNonNull(javaParserChanger);
        this.encodingDetector = Objects.requireNonNull(encodingDetector);
        this.rootedFileMatcher = javaParserChanger.getIncludesExcludesPattern().getRootedMatcher(projectDir);
    }

    @Override
    public boolean supports(Path path) {
        return this.rootedFileMatcher.shouldInspect(path.toFile()) && this.javaParserChanger.supports(path);
    }

    @Override
    public CodemodFileScanningResult run(CodemodInvocationContext context) throws IOException {
        Path file = context.path();
        CompilationUnit cu = this.parser.parseJavaFile(file);
        CodemodFileScanningResult result = this.javaParserChanger.visit(context, cu);
        List<CodemodChange> changes = result.changes();
        if (!changes.isEmpty()) {
            String encodingName = this.encodingDetector.detect(file).orElse("UTF-8");
            Charset encoding = Charset.forName(encodingName);
            String modified = LexicalPreservingPrinter.print((Node)cu);
            Files.writeString(file, (CharSequence)modified, encoding, StandardOpenOption.TRUNCATE_EXISTING);
        }
        return result;
    }
}

