/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder.javaparser;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ParseResult;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.printer.lexicalpreservation.LexicalPreservingPrinter;
import io.codemodder.javaparser.JavaParseException;
import io.codemodder.javaparser.JavaParserFacade;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Objects;
import javax.inject.Provider;

final class DefaultJavaParserFacade
implements JavaParserFacade {
    private final Provider<JavaParser> parserProvider;
    private final ThreadLocal<JavaParser> javaParserRef;

    DefaultJavaParserFacade(Provider<JavaParser> parserProvider) {
        this.parserProvider = Objects.requireNonNull(parserProvider);
        this.javaParserRef = new ThreadLocal();
    }

    @Override
    public CompilationUnit parseJavaFile(Path file) throws IOException {
        ParseResult result;
        JavaParser parser = this.javaParserRef.get();
        if (parser == null) {
            parser = (JavaParser)this.parserProvider.get();
            this.javaParserRef.set(parser);
        }
        if (!(result = parser.parse(file)).isSuccessful()) {
            throw new JavaParseException("Error while parsing file " + file + " encountered problems: " + result.getProblems());
        }
        CompilationUnit cu = (CompilationUnit)result.getResult().orElseThrow();
        LexicalPreservingPrinter.setup((Node)cu);
        return cu;
    }
}

