/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder;

import io.codemodder.CodemodChange;
import io.codemodder.CodemodFileScanningResult;
import io.codemodder.CodemodInvocationContext;
import io.codemodder.CodemodReporterStrategy;
import io.codemodder.DependencyGAV;
import io.codemodder.LineNumbers;
import io.codemodder.RawFileChanger;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public abstract class RegexFileChanger
extends RawFileChanger {
    private final Pattern pattern;
    private final boolean removeEmptyLeftoverLines;
    private final List<DependencyGAV> dependenciesRequired;
    private static final String nl = System.getProperty("line.separator");

    protected RegexFileChanger(Pattern pattern, boolean removeEmptyLeftoverLines, List<DependencyGAV> dependenciesRequired) {
        this.pattern = Objects.requireNonNull(pattern, "pattern");
        this.removeEmptyLeftoverLines = removeEmptyLeftoverLines;
        this.dependenciesRequired = dependenciesRequired;
    }

    protected RegexFileChanger(Pattern pattern, boolean removeEmptyLeftoverLines, List<DependencyGAV> dependenciesRequired, CodemodReporterStrategy reporter) {
        super(reporter);
        this.pattern = Objects.requireNonNull(pattern, "pattern");
        this.removeEmptyLeftoverLines = removeEmptyLeftoverLines;
        this.dependenciesRequired = dependenciesRequired;
    }

    @Override
    public CodemodFileScanningResult visitFile(CodemodInvocationContext context) throws IOException {
        ArrayList<CodemodChange> changes = new ArrayList<CodemodChange>();
        String fileContents = Files.readString(context.path());
        Matcher matcher = this.pattern.matcher(fileContents);
        StringBuilder rebuiltContents = null;
        int lastEnd = 0;
        ArrayList<Integer> possibleEmptylines = new ArrayList<Integer>();
        while (matcher.find()) {
            int start = matcher.start();
            int startLine = LineNumbers.getLineNumberAt(fileContents, start);
            if (!context.lineIncludesExcludes().matches(startLine)) continue;
            if (rebuiltContents == null) {
                rebuiltContents = new StringBuilder(fileContents.length() + 128);
            }
            int end = matcher.end();
            String snippet = fileContents.substring(start, end);
            rebuiltContents.append(fileContents, lastEnd, start);
            changes.add(CodemodChange.from(startLine, this.dependenciesRequired));
            String replacement = this.getReplacementFor(snippet);
            rebuiltContents.append(replacement);
            lastEnd = end;
            if (!this.removeEmptyLeftoverLines || !replacement.isBlank()) continue;
            int lineOfSnippetEnd = LineNumbers.getLineNumberAt(rebuiltContents, rebuiltContents.length() - 1);
            possibleEmptylines.add(lineOfSnippetEnd);
        }
        if (lastEnd == 0) {
            return CodemodFileScanningResult.withOnlyChanges(changes);
        }
        rebuiltContents.append(fileContents.substring(lastEnd));
        if (this.removeEmptyLeftoverLines && !possibleEmptylines.isEmpty()) {
            String buff;
            LineNumberReader lineNumberReader = new LineNumberReader(new StringReader(rebuiltContents.toString()));
            rebuiltContents.setLength(0);
            while ((buff = lineNumberReader.readLine()) != null) {
                int lineNumber = lineNumberReader.getLineNumber();
                if (possibleEmptylines.contains(lineNumber)) {
                    if (StringUtils.isWhitespace((CharSequence)buff)) continue;
                    rebuiltContents.append(buff);
                    rebuiltContents.append(nl);
                    continue;
                }
                rebuiltContents.append(buff);
                rebuiltContents.append(nl);
            }
            rebuiltContents.delete(rebuiltContents.length() - nl.length(), rebuiltContents.length());
        }
        if (changes.isEmpty()) {
            return CodemodFileScanningResult.withOnlyChanges(changes);
        }
        Files.write(context.path(), rebuiltContents.toString().getBytes(), new OpenOption[0]);
        return CodemodFileScanningResult.withOnlyChanges(changes);
    }

    public abstract String getReplacementFor(String var1);
}

