/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

public class Either<L, R> {
    private final L leftValue;
    private final R rightValue;

    private Either(L left, R right) {
        this.leftValue = left;
        this.rightValue = right;
    }

    public boolean isLeft() {
        return this.leftValue != null;
    }

    public boolean isRight() {
        return this.leftValue == null;
    }

    public L getLeft() {
        return this.leftValue;
    }

    public R getRight() {
        return this.rightValue;
    }

    public static <A, B> Either<A, B> left(A value) {
        return new Either<A, Object>(Objects.requireNonNull(value), null);
    }

    public static <A, B> Either<A, B> right(B value) {
        return new Either<Object, B>(null, Objects.requireNonNull(value));
    }

    public <A> Either<A, R> map(Function<L, A> func) {
        if (this.isLeft()) {
            return Either.left(func.apply(this.leftValue));
        }
        return Either.right(this.rightValue);
    }

    public <A> Either<A, R> flatMap(Function<L, Either<A, R>> func) {
        if (this.isLeft()) {
            Either<A, R> other = func.apply(this.leftValue);
            if (other.isLeft()) {
                return Either.left(other.leftValue);
            }
            return Either.right(other.rightValue);
        }
        return Either.right(this.rightValue);
    }

    public <A> Either<L, A> mapRight(Function<R, A> func) {
        if (this.isRight()) {
            return Either.right(func.apply(this.rightValue));
        }
        return Either.left(this.leftValue);
    }

    public <A> Either<L, A> flatMapRight(Function<R, Either<L, A>> func) {
        if (this.isRight()) {
            Either<L, A> other = func.apply(this.rightValue);
            if (other.isRight()) {
                return Either.right(other.rightValue);
            }
            return Either.left(other.leftValue);
        }
        return Either.left(this.leftValue);
    }

    public static <L, R> Either<L, R> fromOptional(Optional<L> maybe, R orElse) {
        return maybe.map(Either::left).orElseGet(() -> Either.right(orElse));
    }

    public Either<L, R> filter(Predicate<L> pred, R orElse) {
        if (this.isLeft()) {
            if (pred.test(this.leftValue)) {
                return this;
            }
            return Either.right(orElse);
        }
        return this;
    }

    public void ifLeftOrElse(Consumer<? super L> leftAction, Consumer<? super R> rightAction) {
        if (this.isLeft()) {
            leftAction.accept(this.getLeft());
        } else {
            rightAction.accept(this.getRight());
        }
    }

    public <A> A ifLeftOrElseGet(Function<? super L, A> leftFunction, Function<? super R, A> rightFunction) {
        if (this.isLeft()) {
            return leftFunction.apply(this.getLeft());
        }
        return rightFunction.apply(this.getRight());
    }

    public String toString() {
        return "Either[" + (this.isLeft() ? this.leftValue : this.rightValue) + "]";
    }
}

