/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder;

import com.contrastsecurity.sarif.Result;
import com.contrastsecurity.sarif.Run;
import com.contrastsecurity.sarif.SarifSchema210;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.codemodder.CodeDirectory;
import io.codemodder.RuleSarif;
import io.codemodder.RuleSarifFactory;
import io.codemodder.SarifParser;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DefaultSarifParser
implements SarifParser {
    private static final Logger log = LoggerFactory.getLogger(DefaultSarifParser.class);

    DefaultSarifParser() {
    }

    private Optional<SarifSchema210> readSarifFile(Path sarifFile) {
        try {
            log.trace("Reading input file: {}", (Object)sarifFile);
            InputStream stream = Files.newInputStream(sarifFile, new OpenOption[0]);
            log.trace("Parsing to SARIF input files");
            SarifSchema210 sarif = (SarifSchema210)new ObjectMapper().readValue(stream, SarifSchema210.class);
            log.trace("Parsed SARIF input files");
            return Optional.of(sarif);
        }
        catch (IOException e) {
            log.error("Problem deserializing SARIF file: {}", (Object)sarifFile, (Object)e);
            return Optional.empty();
        }
    }

    private Optional<Map.Entry<String, RuleSarif>> tryToBuild(String toolName, RuleDescriptor rule, SarifSchema210 sarif, CodeDirectory codeDirectory, List<RuleSarifFactory> factories) {
        for (RuleSarifFactory factory : factories) {
            log.trace("Building SARIF: {}", (Object)factory.getClass().getSimpleName());
            Optional<RuleSarif> maybeRuleSarif = factory.build(toolName, rule.ruleId, rule.messageText, sarif, codeDirectory);
            if (!maybeRuleSarif.isPresent()) continue;
            return Optional.of(Map.entry(toolName, maybeRuleSarif.get()));
        }
        log.info("Found SARIF rule entries from unsupported tool: {}", (Object)toolName);
        return Optional.empty();
    }

    private RuleDescriptor extractRuleId(Result result, Run run) {
        if (result.getRuleId() == null) {
            Integer toolIndex = result.getRule().getToolComponent().getIndex();
            Integer ruleIndex = result.getRule().getIndex();
            Optional<RuleDescriptor> maybeRule = run.getTool().getExtensions().stream().skip(toolIndex.intValue()).findFirst().flatMap(tool -> tool.getRules().stream().skip(ruleIndex.intValue()).findFirst()).map(descriptor -> new RuleDescriptor(descriptor.getId(), null));
            if (maybeRule.isPresent()) {
                return maybeRule.get();
            }
            log.info("Could not find rule id for result.");
            return null;
        }
        return new RuleDescriptor(result.getRuleId(), result.getMessage() != null ? result.getMessage().getText() : null);
    }

    private Stream<Map.Entry<String, RuleSarif>> fromSarif(Run run, SarifSchema210 sarif, CodeDirectory codeDirectory) {
        String toolName = run.getTool().getDriver().getName();
        log.trace("Loading SARIF rule factories");
        List<RuleSarifFactory> factories = ServiceLoader.load(RuleSarifFactory.class).stream().map(ServiceLoader.Provider::get).toList();
        log.trace("Done loading SARIF rule factories");
        List runResults = run.getResults();
        Stream<RuleDescriptor> allResults = runResults != null ? runResults.stream().map(result -> this.extractRuleId((Result)result, run)).filter(Objects::nonNull).filter(ruleDescriptor -> ruleDescriptor.ruleId != null).collect(Collectors.toMap(r -> r.ruleId, r -> r, (r1, r2) -> r1)).values().stream() : Stream.empty();
        return allResults.flatMap(rule -> this.tryToBuild(toolName, (RuleDescriptor)rule, sarif, codeDirectory, factories).stream());
    }

    @Override
    public Map<String, List<RuleSarif>> parseIntoMap(List<Path> sarifFiles, CodeDirectory codeDirectory) {
        HashMap<String, List<RuleSarif>> map = new HashMap<String, List<RuleSarif>>();
        sarifFiles.stream().flatMap(f -> this.readSarifFile((Path)f).stream()).flatMap(sarif -> sarif.getRuns().stream().flatMap(run -> this.fromSarif((Run)run, (SarifSchema210)sarif, codeDirectory))).forEach(p -> {
            log.trace("Merging SARIF results");
            map.merge((String)p.getKey(), new ArrayList<RuleSarif>(Collections.singletonList((RuleSarif)p.getValue())), (l1, l2) -> {
                l1.add((RuleSarif)l2.get(0));
                return l1;
            });
        });
        return map;
    }

    private record RuleDescriptor(String ruleId, String messageText) {
    }
}

