/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder;

import io.codemodder.CodeDirectory;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;

final class DefaultCodeDirectory
implements CodeDirectory {
    private final Path repositoryDir;

    DefaultCodeDirectory(Path repositoryDir) {
        if (!Files.exists(repositoryDir, new LinkOption[0])) {
            throw new IllegalArgumentException("code directory doesn't exist");
        }
        if (!Files.isDirectory(repositoryDir, new LinkOption[0])) {
            throw new IllegalArgumentException("code directory isn't a directory");
        }
        if (!Files.isReadable(repositoryDir)) {
            throw new IllegalArgumentException("code directory isn't readable");
        }
        this.repositoryDir = Objects.requireNonNull(repositoryDir);
    }

    @Override
    public Path asPath() {
        return this.repositoryDir;
    }

    @Override
    public Optional<Path> findFilesWithTrailingPath(String path) throws IOException {
        final AtomicReference found = new AtomicReference();
        final String cleanPath = path.trim().replace("\\\\", "\\").replace("//", "/").replace('\\', File.separatorChar).replace('/', File.separatorChar);
        Files.walkFileTree(this.repositoryDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                if (file.toString().endsWith(cleanPath)) {
                    found.set(file);
                    return FileVisitResult.TERMINATE;
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return Optional.ofNullable((Path)found.get());
    }
}

