/*
 * Decompiled with CFR 0.152.
 */
package io.codemodder;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import io.codemodder.CodeChanger;
import io.codemodder.CodeDirectoryModule;
import io.codemodder.Codemod;
import io.codemodder.CodemodExecutionPriority;
import io.codemodder.CodemodIdPair;
import io.codemodder.CodemodProvider;
import io.codemodder.CodemodRegulator;
import io.codemodder.ParameterArgument;
import io.codemodder.ParameterModule;
import io.codemodder.ReviewGuidance;
import io.codemodder.RuleSarif;
import io.codemodder.XPathStreamProcessorModule;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfoList;
import io.github.classgraph.ScanResult;
import java.lang.reflect.Executable;
import java.lang.reflect.Parameter;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.jetbrains.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CodemodLoader {
    private final List<CodemodIdPair> codemods;
    private static final Logger log = LoggerFactory.getLogger(CodemodLoader.class);
    private static final Pattern codemodIdPattern = Pattern.compile("^([A-Za-z0-9]+):(([A-Za-z0-9]+)/)+([A-Za-z0-9\\-\\.]+)$");

    public CodemodLoader(List<Class<? extends CodeChanger>> unorderedCodemodTypes, CodemodRegulator codemodRegulator, Path repositoryDir, List<String> pathIncludes, List<String> pathExcludes, List<Path> includedFiles, Map<String, List<RuleSarif>> ruleSarifByTool, List<ParameterArgument> codemodParameters, List<Path> sonarJsonFiles, Path defectDojoFindingsJsonFile, Path contrastVulnerabilitiesXmlFilePath) {
        log.trace("Loading providers");
        List<CodemodProvider> providers = ServiceLoader.load(CodemodProvider.class).stream().map(ServiceLoader.Provider::get).toList();
        HashSet<AbstractModule> allModules = new HashSet<AbstractModule>();
        ArrayList<Class<? extends CodeChanger>> orderedCodemodTypes = new ArrayList<Class<? extends CodeChanger>>(unorderedCodemodTypes);
        Optional<List<String>> desiredOrder = codemodRegulator.desiredCodemodIdOrder();
        if (desiredOrder.isPresent()) {
            orderedCodemodTypes.sort((c1, c2) -> {
                String id1 = c1.getAnnotation(Codemod.class).id();
                String id2 = c2.getAnnotation(Codemod.class).id();
                int index1 = ((List)desiredOrder.get()).indexOf(id1);
                int index2 = ((List)desiredOrder.get()).indexOf(id2);
                return Integer.compare(index1, index2);
            });
        } else {
            orderedCodemodTypes.sort((c1, c2) -> {
                CodemodExecutionPriority p1 = c1.getAnnotation(Codemod.class).executionPriority();
                CodemodExecutionPriority p2 = c2.getAnnotation(Codemod.class).executionPriority();
                return CodemodExecutionPriority.priorityOrderComparator.compare(p1, p2);
            });
        }
        HashSet<String> packagesScanned = new HashSet<String>();
        ArrayList<Parameter> injectableParameters = new ArrayList<Parameter>();
        for (Class clazz : orderedCodemodTypes) {
            String packageName = clazz.getPackageName();
            if (packagesScanned.contains(packageName)) continue;
            packagesScanned.add(packageName);
            ScanResult scanResult = new ClassGraph().enableAllInfo().acceptPackagesNonRecursive(new String[]{packageName}).removeTemporaryFilesAfterScan().scan();
            try {
                ClassInfoList classesWithMethodAnnotation = scanResult.getClassesWithMethodAnnotation(Inject.class);
                List injectableClasses = classesWithMethodAnnotation.loadClasses();
                List<Parameter> targetedParams = injectableClasses.stream().map(Class::getDeclaredConstructors).flatMap(Arrays::stream).filter(constructor -> constructor.isAnnotationPresent(Inject.class)).map(Executable::getParameters).flatMap(Arrays::stream).filter(param -> param.getAnnotations().length > 0).toList();
                injectableParameters.addAll(targetedParams);
            }
            finally {
                if (scanResult == null) continue;
                scanResult.close();
            }
        }
        allModules.add(new CodeDirectoryModule(repositoryDir));
        allModules.add(new XPathStreamProcessorModule());
        allModules.add(new ParameterModule(codemodParameters, injectableParameters));
        for (CodemodProvider codemodProvider : providers) {
            List<String> wantsSarif = codemodProvider.wantsSarifToolNames();
            List<RuleSarif> allWantedSarifs = wantsSarif.stream().flatMap(toolName -> ruleSarifByTool.getOrDefault(toolName, List.of()).stream()).toList();
            log.trace("Loading modules from provider: {}", (Object)codemodProvider.getClass().getSimpleName());
            Set<AbstractModule> set = codemodProvider.getModules(repositoryDir, includedFiles, pathIncludes, pathExcludes, orderedCodemodTypes, allWantedSarifs, sonarJsonFiles, defectDojoFindingsJsonFile, contrastVulnerabilitiesXmlFilePath);
            allModules.addAll(set);
        }
        ArrayList<CodemodIdPair> codemods = new ArrayList<CodemodIdPair>();
        log.trace("Instantiating codemods");
        Injector injector = Guice.createInjector(allModules);
        log.trace("Codemods instantiated");
        HashSet<String> codemodIds = new HashSet<String>();
        for (Class clazz : orderedCodemodTypes) {
            Codemod codemodAnnotation = clazz.getAnnotation(Codemod.class);
            CodemodLoader.validateRequiredFields(codemodAnnotation);
            CodeChanger codeChanger = (CodeChanger)injector.getInstance(clazz);
            String codemodId = codemodAnnotation.id();
            if (codemodIds.contains(codemodId)) {
                throw new UnsupportedOperationException("multiple codemods under id: " + codemodId);
            }
            codemodIds.add(codemodId);
            if (!codemodRegulator.isAllowed(codemodId)) continue;
            codemods.add(new CodemodIdPair(codemodId, codeChanger));
        }
        this.codemods = Collections.unmodifiableList(codemods);
    }

    public List<CodemodIdPair> getCodemods() {
        return this.codemods;
    }

    private static void validateRequiredFields(Codemod codemodAnnotation) {
        String id = codemodAnnotation.id();
        if (!CodemodLoader.isValidCodemodId(id)) {
            throw new IllegalArgumentException("must have valid codemod id");
        }
        ReviewGuidance reviewGuidance = codemodAnnotation.reviewGuidance();
        if (reviewGuidance == null) {
            throw new IllegalArgumentException("must have review guidance");
        }
    }

    @VisibleForTesting
    static boolean isValidCodemodId(String codemodId) {
        return codemodIdPattern.matcher(codemodId).matches();
    }
}

