/*
 * Decompiled with CFR 0.152.
 */
package io.cloudstate.kotlinsupport.api.eventsourced;

import com.google.protobuf.Any;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import io.cloudstate.javasupport.ServiceCallFactory;
import io.cloudstate.javasupport.eventsourced.CommandContext;
import io.cloudstate.javasupport.eventsourced.EventContext;
import io.cloudstate.javasupport.eventsourced.EventSourcedContext;
import io.cloudstate.javasupport.eventsourced.EventSourcedEntityCreationContext;
import io.cloudstate.javasupport.eventsourced.EventSourcedEntityFactory;
import io.cloudstate.javasupport.eventsourced.EventSourcedEntityHandler;
import io.cloudstate.javasupport.eventsourced.SnapshotContext;
import io.cloudstate.javasupport.impl.AnySupport;
import io.cloudstate.javasupport.impl.ResolvedEntityFactory;
import io.cloudstate.javasupport.impl.ResolvedServiceMethod;
import io.cloudstate.kotlinsupport.ReflectionHelper;
import io.cloudstate.kotlinsupport.UtilityKt;
import io.cloudstate.kotlinsupport.annotations.EntityId;
import io.cloudstate.kotlinsupport.api.eventsourced.KotlinEventBehaviorReflection;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u00012\u00020\u0002:\b\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001eB#\b\u0016\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB5\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u001a\u0010\n\u001a\u0016\u0012\u0004\u0012\u00020\f\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\r0\u000b\u00a2\u0006\u0002\u0010\u000eJ\u0012\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\u001c\u0010\n\u001a\u0016\u0012\u0004\u0012\u00020\f\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\r0\u000bH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\n\u001a\u0016\u0012\u0004\u0012\u00020\f\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lio/cloudstate/kotlinsupport/api/eventsourced/KotlinAnnotationBasedEventSourced;", "Lio/cloudstate/javasupport/eventsourced/EventSourcedEntityFactory;", "Lio/cloudstate/javasupport/impl/ResolvedEntityFactory;", "entityClass", "Lkotlin/reflect/KClass;", "anySupport", "Lio/cloudstate/javasupport/impl/AnySupport;", "serviceDescriptor", "Lcom/google/protobuf/Descriptors$ServiceDescriptor;", "(Lkotlin/reflect/KClass;Lio/cloudstate/javasupport/impl/AnySupport;Lcom/google/protobuf/Descriptors$ServiceDescriptor;)V", "resolvedMethods", "Lscala/collection/immutable/Map;", "", "Lio/cloudstate/javasupport/impl/ResolvedServiceMethod;", "(Lkotlin/reflect/KClass;Lio/cloudstate/javasupport/impl/AnySupport;Lscala/collection/immutable/Map;)V", "behavior", "Lio/cloudstate/kotlinsupport/api/eventsourced/KotlinEventBehaviorReflection;", "log", "Lorg/slf4j/Logger;", "create", "Lio/cloudstate/javasupport/eventsourced/EventSourcedEntityHandler;", "context", "Lio/cloudstate/javasupport/eventsourced/EventSourcedContext;", "CommandHandlerInvoker", "DelegatingEventContext", "DelegatingEventSourcedContext", "EntityConstructorInvoker", "EntityHandler", "EventHandlerInvoker", "SnapshotHandlerInvoker", "SnapshotInvoker", "cloudstate-kotlin-support"})
public final class KotlinAnnotationBasedEventSourced
implements EventSourcedEntityFactory,
ResolvedEntityFactory {
    private final Logger log;
    private final KotlinEventBehaviorReflection behavior;
    private final KClass<?> entityClass;
    private final AnySupport anySupport;
    private final scala.collection.immutable.Map<String, ResolvedServiceMethod<?, ?>> resolvedMethods;

    @NotNull
    public scala.collection.immutable.Map<String, ResolvedServiceMethod<?, ?>> resolvedMethods() {
        return this.resolvedMethods;
    }

    @NotNull
    public EventSourcedEntityHandler create(@Nullable EventSourcedContext context) {
        return new EntityHandler(this.entityClass, context, this.anySupport, this.behavior);
    }

    public KotlinAnnotationBasedEventSourced(@NotNull KClass<?> entityClass, @NotNull AnySupport anySupport, @NotNull scala.collection.immutable.Map<String, ResolvedServiceMethod<?, ?>> resolvedMethods) {
        Intrinsics.checkParameterIsNotNull(entityClass, (String)"entityClass");
        Intrinsics.checkParameterIsNotNull((Object)anySupport, (String)"anySupport");
        Intrinsics.checkParameterIsNotNull(resolvedMethods, (String)"resolvedMethods");
        this.entityClass = entityClass;
        this.anySupport = anySupport;
        this.resolvedMethods = resolvedMethods;
        this.log = UtilityKt.logger(this);
        this.behavior = new KotlinEventBehaviorReflection(this.entityClass, this.resolvedMethods, this.anySupport);
    }

    public KotlinAnnotationBasedEventSourced(@NotNull KClass<?> entityClass, @NotNull AnySupport anySupport, @NotNull Descriptors.ServiceDescriptor serviceDescriptor) {
        Intrinsics.checkParameterIsNotNull(entityClass, (String)"entityClass");
        Intrinsics.checkParameterIsNotNull((Object)anySupport, (String)"anySupport");
        Intrinsics.checkParameterIsNotNull((Object)serviceDescriptor, (String)"serviceDescriptor");
        scala.collection.immutable.Map map = anySupport.resolveServiceDescriptor(serviceDescriptor);
        Intrinsics.checkExpressionValueIsNotNull((Object)map, (String)"anySupport.resolveServic\u2026riptor(serviceDescriptor)");
        this(entityClass, anySupport, map);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B+\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\u0012H\u0002J$\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u00142\b\u0010\u0016\u001a\u0004\u0018\u00010\u00152\b\u0010\u0004\u001a\u0004\u0018\u00010\u0017H\u0016J\u001c\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u00152\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\u001c\u0010\u001d\u001a\u00020\u00192\b\u0010\u001e\u001a\u0004\u0018\u00010\u00152\b\u0010\u0004\u001a\u0004\u0018\u00010\u001fH\u0016J\u0018\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\b\u0010\u0004\u001a\u0004\u0018\u00010\u001fH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lio/cloudstate/kotlinsupport/api/eventsourced/KotlinAnnotationBasedEventSourced$EntityHandler;", "Lio/cloudstate/javasupport/eventsourced/EventSourcedEntityHandler;", "entityClass", "Lkotlin/reflect/KClass;", "context", "Lio/cloudstate/javasupport/eventsourced/EventSourcedContext;", "anySupport", "Lio/cloudstate/javasupport/impl/AnySupport;", "behavior", "Lio/cloudstate/kotlinsupport/api/eventsourced/KotlinEventBehaviorReflection;", "(Lkotlin/reflect/KClass;Lio/cloudstate/javasupport/eventsourced/EventSourcedContext;Lio/cloudstate/javasupport/impl/AnySupport;Lio/cloudstate/kotlinsupport/api/eventsourced/KotlinEventBehaviorReflection;)V", "entity", "", "log", "Lorg/slf4j/Logger;", "reflectionHelper", "Lio/cloudstate/kotlinsupport/ReflectionHelper;", "entityConstructor", "Lio/cloudstate/javasupport/eventsourced/EventSourcedEntityCreationContext;", "handleCommand", "Ljava/util/Optional;", "Lcom/google/protobuf/Any;", "command", "Lio/cloudstate/javasupport/eventsourced/CommandContext;", "handleEvent", "", "anyEvent", "eventContext", "Lio/cloudstate/javasupport/eventsourced/EventContext;", "handleSnapshot", "snapshot", "Lio/cloudstate/javasupport/eventsourced/SnapshotContext;", "cloudstate-kotlin-support"})
    public static final class EntityHandler
    implements EventSourcedEntityHandler {
        private final Logger log;
        private final ReflectionHelper reflectionHelper;
        private final Object entity;
        private final KClass<?> entityClass;
        private final AnySupport anySupport;
        private final KotlinEventBehaviorReflection behavior;

        public void handleEvent(@Nullable Any anyEvent, @Nullable EventContext eventContext) {
            Object event = this.anySupport.decode(anyEvent);
            Optional<EventHandlerInvoker> handler = this.behavior.getCachedEventHandlerForClass(event.getClass());
            boolean bl = handler.isPresent();
            if (bl) {
                DelegatingEventContext delegatingEventContext;
                EventContext eventContext2 = eventContext;
                if (eventContext2 != null) {
                    EventContext eventContext3 = eventContext2;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    EventContext it = eventContext3;
                    boolean bl4 = false;
                    delegatingEventContext = new DelegatingEventContext(it);
                } else {
                    delegatingEventContext = null;
                }
                DelegatingEventContext ctx = delegatingEventContext;
                Object object = event;
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"event");
                handler.get().invoke(this.entity, object, ctx);
            } else if (!bl) {
                throw (Throwable)new RuntimeException("No event handler found for event " + event.getClass() + " on " + this.entity.getClass().getName());
            }
        }

        @Nullable
        public Optional<Any> handleCommand(@Nullable Any command, @Nullable CommandContext context) {
            Optional<Any> optional;
            Map<String, CommandHandlerInvoker> commandHandlers;
            Object payload = this.anySupport.decode(command);
            Map<String, CommandHandlerInvoker> map = commandHandlers = this.behavior.getCommandHandlers();
            CommandContext commandContext = context;
            String string = commandContext != null ? commandContext.commandName() : null;
            boolean bl = false;
            Map<String, CommandHandlerInvoker> map2 = map;
            boolean bl2 = false;
            if (!map2.containsKey(string)) {
                CommandContext commandContext2 = context;
                throw (Throwable)new RuntimeException("No command handler found for command [" + (commandContext2 != null ? commandContext2.commandName() : null) + "] on " + this.entity.getClass().getName());
            }
            this.log.debug("Calling CommandHandlerInvoker in Entity: " + this.entity);
            CommandContext commandContext3 = context;
            CommandHandlerInvoker commandHandlerInvoker = commandHandlers.get(String.valueOf(commandContext3 != null ? commandContext3.commandName() : null));
            if (commandHandlerInvoker != null) {
                Object object = payload;
                if (object == null) {
                    Intrinsics.throwNpe();
                }
                CommandContext commandContext4 = context;
                if (commandContext4 == null) {
                    Intrinsics.throwNpe();
                }
                optional = commandHandlerInvoker.invoke(this.entity, object, commandContext4);
            } else {
                optional = null;
            }
            return optional;
        }

        public void handleSnapshot(@Nullable Any snapshot, @Nullable SnapshotContext context) {
            Object payload = this.anySupport.decode(snapshot);
            Optional<SnapshotHandlerInvoker> handler = this.behavior.getCachedSnapshotHandlerForClass(payload.getClass());
            boolean bl = handler.isPresent();
            if (bl) {
                Object object = payload;
                if (object == null) {
                    Intrinsics.throwNpe();
                }
                SnapshotContext snapshotContext = context;
                if (snapshotContext == null) {
                    Intrinsics.throwNpe();
                }
                handler.get().invoke(this.entity, object, snapshotContext);
            } else if (!bl) {
                throw (Throwable)new RuntimeException("No snapshot handler found for event " + payload.getClass() + " on " + this.entity.getClass().getName());
            }
        }

        @NotNull
        public Optional<Any> snapshot(@Nullable SnapshotContext context) {
            SnapshotContext snapshotContext;
            boolean bl = this.behavior.getSnapshotInvoker().isPresent();
            if (bl) {
                snapshotContext = context;
                if (snapshotContext == null) {
                    Intrinsics.throwNpe();
                }
            } else {
                if (!bl) {
                    throw (Throwable)new RuntimeException("No snapshot invoker found for entity " + this.entity.getClass().getName());
                }
                throw new NoWhenBranchMatchedException();
            }
            return this.behavior.getSnapshotInvoker().get().invoke(this.entity, snapshotContext);
        }

        private final Object entityConstructor(EventSourcedEntityCreationContext context) {
            Boolean bl;
            Constructor<?>[] constructors;
            this.log.debug("Call constructor in " + this.entityClass.getQualifiedName());
            if (constructors != null) {
                Constructor<?>[] constructorArray = constructors = JvmClassMappingKt.getJavaClass(this.entityClass).getConstructors();
                boolean bl2 = false;
                Constructor<?>[] constructorArray2 = constructorArray;
                boolean bl3 = false;
                bl = !(constructorArray2.length == 0);
            } else {
                bl = null;
            }
            if (bl == null) {
                Intrinsics.throwNpe();
            }
            if (bl.booleanValue() && constructors.length == 1) {
                AccessibleObject accessibleObject = this.reflectionHelper.ensureAccessible((AccessibleObject)constructors[0]);
                Intrinsics.checkExpressionValueIsNotNull((Object)accessibleObject, (String)"reflectionHelper.ensureAccessible(constructors[0])");
                return new EntityConstructorInvoker((Constructor)accessibleObject, context).invoke();
            }
            throw (Throwable)new RuntimeException("Only a single constructor is allowed on event sourced entities: " + this.entityClass);
        }

        public EntityHandler(@NotNull KClass<?> entityClass, @Nullable EventSourcedContext context, @NotNull AnySupport anySupport, @NotNull KotlinEventBehaviorReflection behavior) {
            Intrinsics.checkParameterIsNotNull(entityClass, (String)"entityClass");
            Intrinsics.checkParameterIsNotNull((Object)anySupport, (String)"anySupport");
            Intrinsics.checkParameterIsNotNull((Object)behavior, (String)"behavior");
            this.entityClass = entityClass;
            this.anySupport = anySupport;
            this.behavior = behavior;
            this.log = UtilityKt.logger(this);
            this.reflectionHelper = new ReflectionHelper();
            EventSourcedContext eventSourcedContext = context;
            if (eventSourcedContext == null) {
                Intrinsics.throwNpe();
            }
            this.entity = this.entityConstructor(new DelegatingEventSourcedContext(eventSourcedContext));
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u000f\u001a\u00020\u000bH\u0002J\u0006\u0010\u0010\u001a\u00020\u0001J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000bH\u0002R\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R6\u0010\t\u001a(\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b \f*\u0014\u0012\u000e\b\u0001\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\r\u00a8\u0006\u0014"}, d2={"Lio/cloudstate/kotlinsupport/api/eventsourced/KotlinAnnotationBasedEventSourced$EntityConstructorInvoker;", "", "constructor", "Ljava/lang/reflect/Constructor;", "context", "Lio/cloudstate/javasupport/eventsourced/EventSourcedEntityCreationContext;", "(Ljava/lang/reflect/Constructor;Lio/cloudstate/javasupport/eventsourced/EventSourcedEntityCreationContext;)V", "log", "Lorg/slf4j/Logger;", "params", "", "Ljava/lang/reflect/Parameter;", "kotlin.jvm.PlatformType", "[Ljava/lang/reflect/Parameter;", "getArguments", "it", "invoke", "isEntityId", "", "parameter", "cloudstate-kotlin-support"})
    public static final class EntityConstructorInvoker {
        private final Logger log;
        private final Parameter[] params;
        private final Constructor<?> constructor;
        private final EventSourcedEntityCreationContext context;

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Object invoke() {
            void $this$toTypedArray$iv;
            Object[] objectArray;
            Object object;
            void $this$mapTo$iv$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)this.params, (String)"params");
            Parameter[] parameterArray = this.params;
            boolean bl = false;
            if (parameterArray.length == 0) {
                Object obj = this.constructor.newInstance(new Object[0]);
                Intrinsics.checkExpressionValueIsNotNull(obj, (String)"constructor.newInstance()");
                return obj;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)this.params, (String)"params");
            Object $this$map$iv = this.params;
            boolean $i$f$map = false;
            Parameter[] parameterArray2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((Parameter[])$this$map$iv).length);
            boolean $i$f$mapTo = false;
            void var7_8 = $this$mapTo$iv$iv;
            int n = ((void)var7_8).length;
            for (int i = 0; i < n; ++i) {
                void it;
                void item$iv$iv;
                void var11_12 = item$iv$iv = var7_8[i];
                object = destination$iv$iv;
                boolean bl2 = false;
                void v1 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
                objectArray = this.getArguments((Parameter)v1);
                object.add(objectArray);
            }
            List args = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
            this.log.trace("Constructor args size: " + this.params.length + ". Params found: " + args.size());
            $this$map$iv = args;
            object = this.constructor;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            Object[] objectArray2 = thisCollection$iv.toArray(new Object[0]);
            if (objectArray2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            objectArray = objectArray2;
            Object t = ((Constructor)object).newInstance(Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull(t, (String)"constructor.newInstance(*args.toTypedArray())");
            return t;
        }

        private final Object getArguments(Parameter it) {
            Object object;
            if (this.isEntityId(it)) {
                if (!it.getType().isAssignableFrom(String.class) || !it.getType().isAssignableFrom(String.class)) {
                    this.log.warn("Type of parameter annotated with @EntityId. Type: " + it.getType());
                    throw (Throwable)new RuntimeException("@EntityId annotated parameter has type " + it.getType() + ", must be String.");
                }
                this.log.debug("Type of parameter annotated with @EntityId. " + "Type: " + it.getType() + ". Value param type: " + this.context.entityId().getClass() + ". Value: " + this.context.entityId());
                object = it.getType().cast(this.context.entityId());
            } else if (it.getType().isAssignableFrom(this.context.getClass())) {
                object = this.context;
            } else {
                this.log.trace("Param " + it + ". Name: " + it.getName() + " Type: " + it.getType());
                object = null;
            }
            return object;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isEntityId(Parameter parameter) {
            Annotation[] annotationArray = parameter.getDeclaredAnnotations();
            Intrinsics.checkExpressionValueIsNotNull((Object)annotationArray, (String)"parameter.declaredAnnotations");
            Annotation[] annotationArray2 = annotationArray;
            boolean bl = false;
            Annotation[] annotationArray3 = annotationArray2;
            boolean bl2 = false;
            if (!(annotationArray3.length == 0)) {
                if (parameter.isAnnotationPresent(EntityId.class)) return true;
            }
            Annotation[] annotationArray4 = parameter.getDeclaredAnnotations();
            Intrinsics.checkExpressionValueIsNotNull((Object)annotationArray4, (String)"parameter.declaredAnnotations");
            annotationArray2 = annotationArray4;
            bl = false;
            annotationArray3 = annotationArray2;
            bl2 = false;
            if (annotationArray3.length == 0) {
                return false;
            }
            boolean bl3 = false;
            if (bl3) return false;
            boolean bl4 = true;
            if (!bl4) return false;
            if (!parameter.isAnnotationPresent(io.cloudstate.javasupport.EntityId.class)) return false;
            return true;
        }

        public EntityConstructorInvoker(@NotNull Constructor<?> constructor, @NotNull EventSourcedEntityCreationContext context) {
            Intrinsics.checkParameterIsNotNull(constructor, (String)"constructor");
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            this.constructor = constructor;
            this.context = context;
            this.log = UtilityKt.logger(this);
            this.params = this.constructor.getParameters();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\"\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\f\u001a\u00020\u00012\b\u0010\r\u001a\u0004\u0018\u00010\u000eR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lio/cloudstate/kotlinsupport/api/eventsourced/KotlinAnnotationBasedEventSourced$EventHandlerInvoker;", "", "method", "Ljava/lang/reflect/Method;", "reflectionHelper", "Lio/cloudstate/kotlinsupport/ReflectionHelper;", "(Ljava/lang/reflect/Method;Lio/cloudstate/kotlinsupport/ReflectionHelper;)V", "log", "Lorg/slf4j/Logger;", "invoke", "", "entity", "event", "ctx", "Lio/cloudstate/kotlinsupport/api/eventsourced/KotlinAnnotationBasedEventSourced$DelegatingEventContext;", "cloudstate-kotlin-support"})
    public static final class EventHandlerInvoker {
        private final Logger log;
        private final Method method;
        private final ReflectionHelper reflectionHelper;

        public final void invoke(@Nullable Object entity, @NotNull Object event, @Nullable DelegatingEventContext ctx) {
            Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
            DelegatingEventContext delegatingEventContext = ctx;
            if (delegatingEventContext == null) {
                Intrinsics.throwNpe();
            }
            Object[] parameters = this.reflectionHelper.getParameters(this.method, event, delegatingEventContext);
            this.log.debug("EventHandlerInvoker method " + this.method.getName() + " with " + this.method.getParameterCount() + " params");
            this.method.invoke(entity, Arrays.copyOf(parameters, parameters.length));
        }

        public EventHandlerInvoker(@NotNull Method method, @NotNull ReflectionHelper reflectionHelper) {
            Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
            Intrinsics.checkParameterIsNotNull((Object)reflectionHelper, (String)"reflectionHelper");
            this.method = method;
            this.reflectionHelper = reflectionHelper;
            this.log = UtilityKt.logger(this);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\u0010\u0006\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ \u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J&\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\b\u0010\u0017\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0018\u001a\u00020\u00012\u0006\u0010\u0019\u001a\u00020\u001aR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n \u000f*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lio/cloudstate/kotlinsupport/api/eventsourced/KotlinAnnotationBasedEventSourced$CommandHandlerInvoker;", "", "method", "Ljava/lang/reflect/Method;", "anySupport", "Lio/cloudstate/javasupport/impl/AnySupport;", "serviceMethod", "Lio/cloudstate/javasupport/impl/ResolvedServiceMethod;", "reflectionHelper", "Lio/cloudstate/kotlinsupport/ReflectionHelper;", "(Ljava/lang/reflect/Method;Lio/cloudstate/javasupport/impl/AnySupport;Lio/cloudstate/javasupport/impl/ResolvedServiceMethod;Lio/cloudstate/kotlinsupport/ReflectionHelper;)V", "log", "Lorg/slf4j/Logger;", "name", "", "kotlin.jvm.PlatformType", "outputType", "Lcom/google/protobuf/Descriptors$Descriptor;", "handleResult", "Ljava/util/Optional;", "Lcom/google/protobuf/Any;", "result", "invoke", "entityInstance", "command", "context", "Lio/cloudstate/javasupport/eventsourced/CommandContext;", "cloudstate-kotlin-support"})
    public static final class CommandHandlerInvoker {
        private final Logger log;
        private final String name;
        private final Descriptors.Descriptor outputType;
        private final Method method;
        private final AnySupport anySupport;
        private final ResolvedServiceMethod<?, ?> serviceMethod;
        private final ReflectionHelper reflectionHelper;

        @NotNull
        public final Optional<Any> invoke(@Nullable Object entityInstance, @NotNull Object command, @NotNull CommandContext context) {
            Class<?> clazz;
            Intrinsics.checkParameterIsNotNull((Object)command, (String)"command");
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            this.log.debug("CommandHandlerInvoker service method " + this.name + " with Entity method " + this.method.getName() + ' ' + "in " + ((clazz = entityInstance) != null && (clazz = clazz.getClass()) != null ? clazz.getName() : null) + ". " + "Declared Class Method: " + this.method.getDeclaringClass());
            Object[] parameters = this.reflectionHelper.getParameters(this.method, command, context, this.anySupport);
            Object result = null;
            this.log.debug("CommandHandlerInvoker method " + this.method.getName() + " with " + this.method.getParameterCount() + " params");
            if (this.method.getParameterCount() == 0) {
                result = this.method.invoke(entityInstance, new Object[0]);
                Descriptors.Descriptor descriptor = this.outputType;
                Intrinsics.checkExpressionValueIsNotNull((Object)descriptor, (String)"outputType");
                return this.handleResult(result, descriptor);
            }
            Object[] $this$forEach$iv = parameters;
            boolean $i$f$forEach = false;
            Object[] objectArray = $this$forEach$iv;
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                Class<?> clazz2;
                Class<?> element$iv;
                Class<?> it = element$iv = objectArray[i];
                boolean bl = false;
                this.log.debug("CommandHandlerInvoker invoke with param name " + ((clazz2 = it) != null && (clazz2 = clazz2.getClass()) != null ? clazz2.getTypeName() : null) + ". Value " + it);
            }
            try {
                result = this.method.invoke(entityInstance, Arrays.copyOf(parameters, parameters.length));
            }
            catch (Throwable e) {
                this.log.warn("Handle FailInvoke (CommandContext.fail(...)) or Generic Failure occurred");
                if (this.log.isDebugEnabled()) {
                    e.printStackTrace();
                }
                Descriptors.Descriptor descriptor = this.outputType;
                Intrinsics.checkExpressionValueIsNotNull((Object)descriptor, (String)"outputType");
                return this.handleResult(result, descriptor);
            }
            Descriptors.Descriptor descriptor = this.outputType;
            Intrinsics.checkExpressionValueIsNotNull((Object)descriptor, (String)"outputType");
            return this.handleResult(result, descriptor);
        }

        private final Optional<Any> handleResult(Object result, Descriptors.Descriptor outputType) {
            Optional<Any> optional;
            if (result == null) {
                Optional optional2 = Optional.empty();
                optional = optional2;
                Intrinsics.checkExpressionValueIsNotNull(optional2, (String)"Optional.empty()");
            } else {
                Optional<Any> optional3 = Optional.of(Any.pack((Message)((Message)result)));
                optional = optional3;
                Intrinsics.checkExpressionValueIsNotNull(optional3, (String)"Optional.of(Any.pack(result as Message))");
            }
            return optional;
        }

        public CommandHandlerInvoker(@NotNull Method method, @NotNull AnySupport anySupport, @NotNull ResolvedServiceMethod<?, ?> serviceMethod2, @NotNull ReflectionHelper reflectionHelper) {
            Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
            Intrinsics.checkParameterIsNotNull((Object)anySupport, (String)"anySupport");
            Intrinsics.checkParameterIsNotNull(serviceMethod2, (String)"serviceMethod");
            Intrinsics.checkParameterIsNotNull((Object)reflectionHelper, (String)"reflectionHelper");
            this.method = method;
            this.anySupport = anySupport;
            this.serviceMethod = serviceMethod2;
            this.reflectionHelper = reflectionHelper;
            this.log = UtilityKt.logger(this);
            Descriptors.MethodDescriptor methodDescriptor = this.serviceMethod.method();
            Intrinsics.checkExpressionValueIsNotNull((Object)methodDescriptor, (String)"serviceMethod.method()");
            this.name = methodDescriptor.getFullName();
            Descriptors.MethodDescriptor methodDescriptor2 = this.serviceMethod.method();
            Intrinsics.checkExpressionValueIsNotNull((Object)methodDescriptor2, (String)"serviceMethod.method()");
            this.outputType = methodDescriptor2.getOutputType();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00012\b\u0010\n\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lio/cloudstate/kotlinsupport/api/eventsourced/KotlinAnnotationBasedEventSourced$SnapshotHandlerInvoker;", "", "method", "Ljava/lang/reflect/Method;", "reflectionHelper", "Lio/cloudstate/kotlinsupport/ReflectionHelper;", "(Ljava/lang/reflect/Method;Lio/cloudstate/kotlinsupport/ReflectionHelper;)V", "invoke", "", "entityInstance", "payload", "context", "Lio/cloudstate/javasupport/eventsourced/SnapshotContext;", "cloudstate-kotlin-support"})
    public static final class SnapshotHandlerInvoker {
        private final Method method;
        private final ReflectionHelper reflectionHelper;

        public final void invoke(@NotNull Object entityInstance, @Nullable Object payload, @NotNull SnapshotContext context) {
            Object[] parameters;
            Intrinsics.checkParameterIsNotNull((Object)entityInstance, (String)"entityInstance");
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Object[] objectArray = parameters = this.reflectionHelper.getParameters(this.method, payload, context);
            boolean bl = false;
            Object[] objectArray2 = objectArray;
            boolean bl2 = false;
            if (!(objectArray2.length == 0)) {
                this.method.invoke(entityInstance, Arrays.copyOf(parameters, parameters.length));
            }
        }

        public SnapshotHandlerInvoker(@NotNull Method method, @NotNull ReflectionHelper reflectionHelper) {
            Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
            Intrinsics.checkParameterIsNotNull((Object)reflectionHelper, (String)"reflectionHelper");
            this.method = method;
            this.reflectionHelper = reflectionHelper;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\u0010\n\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lio/cloudstate/kotlinsupport/api/eventsourced/KotlinAnnotationBasedEventSourced$SnapshotInvoker;", "", "method", "Ljava/lang/reflect/Method;", "reflectionHelper", "Lio/cloudstate/kotlinsupport/ReflectionHelper;", "(Ljava/lang/reflect/Method;Lio/cloudstate/kotlinsupport/ReflectionHelper;)V", "invoke", "Ljava/util/Optional;", "Lcom/google/protobuf/Any;", "entityInstance", "context", "Lio/cloudstate/javasupport/eventsourced/SnapshotContext;", "cloudstate-kotlin-support"})
    public static final class SnapshotInvoker {
        private final Method method;
        private final ReflectionHelper reflectionHelper;

        @NotNull
        public final Optional<Any> invoke(@Nullable Object entityInstance, @NotNull SnapshotContext context) {
            Object[] parameters;
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Object[] objectArray = parameters = this.reflectionHelper.getParameters(this.method, null, context);
            boolean bl = false;
            if (objectArray.length == 0) {
                Object object = this.method.invoke(entityInstance, new Object[0]);
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.google.protobuf.Message");
                }
                Optional<Any> optional = Optional.of(Any.pack((Message)((Message)object)));
                Intrinsics.checkExpressionValueIsNotNull(optional, (String)"Optional.of(Any.pack(met\u2026ityInstance) as Message))");
                return optional;
            }
            Object object = this.method.invoke(entityInstance, new Object[]{parameters});
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.google.protobuf.Message");
            }
            Optional<Any> optional = Optional.of(Any.pack((Message)((Message)object)));
            Intrinsics.checkExpressionValueIsNotNull(optional, (String)"Optional.of(Any.pack(met\u2026 parameters) as Message))");
            return optional;
        }

        public SnapshotInvoker(@NotNull Method method, @NotNull ReflectionHelper reflectionHelper) {
            Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
            Intrinsics.checkParameterIsNotNull((Object)reflectionHelper, (String)"reflectionHelper");
            this.method = method;
            this.reflectionHelper = reflectionHelper;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lio/cloudstate/kotlinsupport/api/eventsourced/KotlinAnnotationBasedEventSourced$DelegatingEventContext;", "Lio/cloudstate/javasupport/eventsourced/EventContext;", "delegate", "(Lio/cloudstate/javasupport/eventsourced/EventContext;)V", "entityId", "", "sequenceNumber", "", "serviceCallFactory", "Lio/cloudstate/javasupport/ServiceCallFactory;", "cloudstate-kotlin-support"})
    public static final class DelegatingEventContext
    implements EventContext {
        private final EventContext delegate;

        @NotNull
        public String entityId() {
            String string = this.delegate.entityId();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"delegate.entityId()");
            return string;
        }

        @NotNull
        public ServiceCallFactory serviceCallFactory() {
            ServiceCallFactory serviceCallFactory = this.delegate.serviceCallFactory();
            Intrinsics.checkExpressionValueIsNotNull((Object)serviceCallFactory, (String)"delegate.serviceCallFactory()");
            return serviceCallFactory;
        }

        public long sequenceNumber() {
            return this.delegate.sequenceNumber();
        }

        public DelegatingEventContext(@NotNull EventContext delegate) {
            Intrinsics.checkParameterIsNotNull((Object)delegate, (String)"delegate");
            this.delegate = delegate;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lio/cloudstate/kotlinsupport/api/eventsourced/KotlinAnnotationBasedEventSourced$DelegatingEventSourcedContext;", "Lio/cloudstate/javasupport/eventsourced/EventSourcedEntityCreationContext;", "delegate", "Lio/cloudstate/javasupport/eventsourced/EventSourcedContext;", "(Lio/cloudstate/javasupport/eventsourced/EventSourcedContext;)V", "entityId", "", "serviceCallFactory", "Lio/cloudstate/javasupport/ServiceCallFactory;", "cloudstate-kotlin-support"})
    public static final class DelegatingEventSourcedContext
    implements EventSourcedEntityCreationContext {
        private final EventSourcedContext delegate;

        @NotNull
        public String entityId() {
            String string = this.delegate.entityId();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"delegate.entityId()");
            return string;
        }

        @NotNull
        public ServiceCallFactory serviceCallFactory() {
            ServiceCallFactory serviceCallFactory = this.delegate.serviceCallFactory();
            Intrinsics.checkExpressionValueIsNotNull((Object)serviceCallFactory, (String)"delegate.serviceCallFactory()");
            return serviceCallFactory;
        }

        public DelegatingEventSourcedContext(@NotNull EventSourcedContext delegate) {
            Intrinsics.checkParameterIsNotNull((Object)delegate, (String)"delegate");
            this.delegate = delegate;
        }
    }
}

