package io.ciogram.types

import kotlinx.serialization.*

@Serializable
public data class User(
    public val id: Long,
    @SerialName("is_bot") public val isBot: Boolean,
    @SerialName("first_name") public val firstName: String,
    @SerialName("last_name") public val lastName: String? = null,
    public val username: String? = null,
    @SerialName("language_code") public val languageCode: String? = null,
    @SerialName("can_join_groups") public val canJoinGroups: Boolean? = null,
    @SerialName("can_read_all_group_messages") public val canReadAllGroupMessages: Boolean? = null,
    @SerialName("supports_inline_queries") public val supportsInlineQueries: Boolean? = null
)