package io.ciogram.types

import kotlinx.serialization.*

@Serializable
public data class WebhookInfo(
    public val url: String,
    @SerialName("has_custom_certificate") public val hasCustomCertificate: Boolean,
    @SerialName("pending_update_count") public val pendingUpdateCount: Int,
    @SerialName("ip_address") public val ipAddress: String? = null,
    @SerialName("last_error_date") public val lastErrorDate: Long? = null,
    @SerialName("last_error_message") public val lastErrorMessage: String? = null,
    @SerialName("max_connections") public val maxConnections: Int? = null,
    @SerialName("allowed_updates") public val allowedUpdates: List<String>? = null
)