package io.ciogram.types

import kotlinx.serialization.*

@Serializable
public data class Poll(
    public val id: String,
    public val question: String,
    public val options: List<PollOption>,
    @SerialName("total_voter_count") public val totalVoterCount: Int,
    @SerialName("is_closed") public val isClosed: Boolean,
    @SerialName("is_anonymous") public val isAnonymous: Boolean,
    public val type: String,
    @SerialName("allows_multiple_answers") public val allowsMultipleAnswers: Boolean,
    @SerialName("correct_option_id") public val correctOptionId: Int? = null,
    public val explanation: String? = null,
    @SerialName("explanation_entities") public val explanationEntities: List<MessageEntity>? = null,
    @SerialName("open_period") public val openPeriod: Long? = null,
    @SerialName("close_date") public val closeDate: Long? = null
)