package io.ciogram.types

import kotlinx.serialization.*

@Serializable
public data class Message(
    @SerialName("message_id") public val messageId: Int,
    public val from: User? = null,
    @SerialName("sender_chat") public val senderChat: Chat? = null,
    public val date: Long,
    public val chat: Chat,
    @SerialName("forward_from") public val forwardFrom: User? = null,
    @SerialName("forward_from_chat") public val forwardFromChat: Chat? = null,
    @SerialName("forward_from_message_id") public val forwardFromMessageId: Int? = null,
    @SerialName("forward_signature") public val forwardSignature: String? = null,
    @SerialName("forward_sender_name") public val forwardSenderName: String? = null,
    @SerialName("forward_date") public val forwardDate: Long? = null,
    @SerialName("is_automatic_forward") public val isAutomaticForward: Boolean? = null,
    @SerialName("reply_to_message") public val replyToMessage: Message? = null,
    @SerialName("via_bot") public val viaBot: User? = null,
    @SerialName("edit_date") public val editDate: Long? = null,
    @SerialName("has_protected_content") public val hasProtectedContent: Boolean? = null,
    @SerialName("media_group_id") public val mediaGroupId: String? = null,
    @SerialName("author_signature") public val authorSignature: String? = null,
    public val text: String? = null,
    public val entities: List<MessageEntity>? = null,
    public val animation: Animation? = null,
    public val audio: Audio? = null,
    public val document: Document? = null,
    public val photo: List<PhotoSize>? = null,
    public val sticker: Sticker? = null,
    public val video: Video? = null,
    @SerialName("video_note") public val videoNote: VideoNote? = null,
    public val voice: Voice? = null,
    public val caption: String? = null,
    @SerialName("caption_entities") public val captionEntities: List<MessageEntity>? = null,
    public val contact: Contact? = null,
    public val dice: Dice? = null,
    public val game: Game? = null,
    public val poll: Poll? = null,
    public val venue: Venue? = null,
    public val location: Location? = null,
    @SerialName("new_chat_members") public val newChatMembers: List<User>? = null,
    @SerialName("left_chat_member") public val leftChatMember: User? = null,
    @SerialName("new_chat_title") public val newChatTitle: String? = null,
    @SerialName("new_chat_photo") public val newChatPhoto: List<PhotoSize>? = null,
    @SerialName("delete_chat_photo") public val deleteChatPhoto: Boolean? = null,
    @SerialName("group_chat_created") public val groupChatCreated: Boolean? = null,
    @SerialName("supergroup_chat_created") public val supergroupChatCreated: Boolean? = null,
    @SerialName("channel_chat_created") public val channelChatCreated: Boolean? = null,
    @SerialName("message_auto_delete_timer_changed") public val messageAutoDeleteTimerChanged: MessageAutoDeleteTimerChanged? = null,
    @SerialName("migrate_to_chat_id") public val migrateToChatId: Long? = null,
    @SerialName("migrate_from_chat_id") public val migrateFromChatId: Long? = null,
    @SerialName("pinned_message") public val pinnedMessage: Message? = null,
    public val invoice: Invoice? = null,
    @SerialName("successful_payment") public val successfulPayment: SuccessfulPayment? = null,
    @SerialName("connected_website") public val connectedWebsite: String? = null,
    @SerialName("passport_data") public val passportData: PassportData? = null,
    @SerialName("proximity_alert_triggered") public val proximityAlertTriggered: ProximityAlertTriggered? = null,
    @SerialName("voice_chat_scheduled") public val voiceChatScheduled: VoiceChatScheduled? = null,
    @SerialName("voice_chat_started") public val voiceChatStarted: VoiceChatStarted? = null,
    @SerialName("voice_chat_ended") public val voiceChatEnded: VoiceChatEnded? = null,
    @SerialName("voice_chat_participants_invited") public val voiceChatParticipantsInvited: VoiceChatParticipantsInvited? = null,
    @SerialName("reply_markup") public val replyMarkup: InlineKeyboardMarkup? = null
)