package io.ciogram.types

import kotlinx.serialization.*
import kotlinx.serialization.json.JsonClassDiscriminator

@Serializable
@JsonClassDiscriminator("status")
@OptIn(ExperimentalSerializationApi::class)
public sealed class ChatMember {
    public abstract val status: String
}

@Serializable
@SerialName("creator")
public data class ChatMemberOwner(
    public val user: User,
    @SerialName("is_anonymous") public val isAnonymous: Boolean,
    @SerialName("custom_title") public val customTitle: String? = null
) : ChatMember() {
    @Transient
    public override val status: String = "creator"
}

@Serializable
@SerialName("administrator")
public data class ChatMemberAdministrator(
    public val user: User,
    @SerialName("can_be_edited") public val canBeEdited: Boolean,
    @SerialName("is_anonymous") public val isAnonymous: Boolean,
    @SerialName("can_manage_chat") public val canManageChat: Boolean,
    @SerialName("can_delete_messages") public val canDeleteMessages: Boolean,
    @SerialName("can_manage_voice_chats") public val canManageVoiceChats: Boolean,
    @SerialName("can_restrict_members") public val canRestrictMembers: Boolean,
    @SerialName("can_promote_members") public val canPromoteMembers: Boolean,
    @SerialName("can_change_info") public val canChangeInfo: Boolean,
    @SerialName("can_invite_users") public val canInviteUsers: Boolean,
    @SerialName("can_post_messages") public val canPostMessages: Boolean? = null,
    @SerialName("can_edit_messages") public val canEditMessages: Boolean? = null,
    @SerialName("can_pin_messages") public val canPinMessages: Boolean? = null,
    @SerialName("custom_title") public val customTitle: String? = null
) : ChatMember() {
    @Transient
    public override val status: String = "administrator"
}

@Serializable
@SerialName("member")
public data class ChatMemberMember(
    public val user: User
) : ChatMember() {
    @Transient
    public override val status: String = "member"
}

@Serializable
@SerialName("restricted")
public data class ChatMemberRestricted(
    public val user: User,
    @SerialName("is_member") public val isMember: Boolean,
    @SerialName("can_change_info") public val canChangeInfo: Boolean,
    @SerialName("can_invite_users") public val canInviteUsers: Boolean,
    @SerialName("can_pin_messages") public val canPinMessages: Boolean,
    @SerialName("can_send_messages") public val canSendMessages: Boolean,
    @SerialName("can_send_media_messages") public val canSendMediaMessages: Boolean,
    @SerialName("can_send_polls") public val canSendPolls: Boolean,
    @SerialName("can_send_other_messages") public val canSendOtherMessages: Boolean,
    @SerialName("can_add_web_page_previews") public val canAddWebPagePreviews: Boolean,
    @SerialName("until_date") public val untilDate: Long
) : ChatMember() {
    @Transient
    public override val status: String = "restricted"
}

@Serializable
@SerialName("left")
public data class ChatMemberLeft(
    public val user: User
) : ChatMember() {
    @Transient
    public override val status: String = "left"
}

@Serializable
@SerialName("kicked")
public data class ChatMemberBanned(
    public val user: User,
    @SerialName("until_date") public val untilDate: Long
) : ChatMember() {
    @Transient
    public override val status: String = "kicked"
}