/*
 * Decompiled with CFR 0.152.
 */
package io.cdsoft.sf.messaging.internal.client.cometd;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.cometd.bayeux.Message;
import org.cometd.bayeux.client.ClientSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplayExtension
extends ClientSession.Extension.Adapter {
    private static final Logger LOG = LoggerFactory.getLogger(ReplayExtension.class);
    private static final String EXTENSION_NAME = "replay";
    private static final String EVENT_NAME = "event";
    private static final String REPLAY_ID_NAME = "replayId";
    private final ConcurrentMap<String, Long> dataMap = new ConcurrentHashMap<String, Long>();
    private final AtomicBoolean supported = new AtomicBoolean();

    public void addOrUpdateChannelReplayId(String channelName, long replayId) {
        this.dataMap.merge(channelName, replayId, (a, b) -> Math.max(b, a));
        LOG.debug("Updated replayId in replay extension for channel [{}] to: {}", (Object)channelName, this.dataMap.get(channelName));
    }

    public void removeChannelReplayId(String channelName) {
        this.dataMap.remove(channelName);
    }

    public boolean rcv(ClientSession session, Message.Mutable message) {
        Map event = (Map)message.getDataAsMap(true).get(EVENT_NAME);
        Object value = null;
        if (event != null) {
            value = event.get(REPLAY_ID_NAME);
        }
        Long replayId = value instanceof Long ? (Long)value : (value instanceof Number ? Long.valueOf(((Number)value).longValue()) : null);
        if (this.supported.get() && replayId != null) {
            try {
                LOG.debug("Updating replayId for {} to {}", (Object)message.getChannel(), (Object)replayId);
                this.dataMap.put(message.getChannel(), replayId);
            }
            catch (ClassCastException e) {
                return false;
            }
        }
        return true;
    }

    public boolean rcvMeta(ClientSession session, Message.Mutable message) {
        switch (message.getChannel()) {
            case "/meta/handshake": {
                Map ext = message.getExt(false);
                this.supported.set(ext != null && Boolean.TRUE.equals(ext.get(EXTENSION_NAME)));
                break;
            }
        }
        return true;
    }

    public boolean sendMeta(ClientSession session, Message.Mutable message) {
        switch (message.getChannel()) {
            case "/meta/handshake": {
                message.getExt(true).put(EXTENSION_NAME, Boolean.TRUE);
                break;
            }
            case "/meta/subscribe": {
                if (!this.supported.get()) break;
                message.getExt(true).put(EXTENSION_NAME, this.dataMap);
                break;
            }
        }
        return true;
    }
}

