/*
 * Decompiled with CFR 0.152.
 */
package io.cdsoft.sf.messaging.api.consumer;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.cdsoft.sf.messaging.api.consumer.JsonEventConsumer;
import io.cdsoft.sf.messaging.api.model.PushTopicEvent;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JacksonPushTopicEventConsumer<T>
implements JsonEventConsumer {
    private static final Logger log = LoggerFactory.getLogger(JacksonPushTopicEventConsumer.class);
    private final JavaType eventType;
    private final ObjectMapper objectMapper;

    public JacksonPushTopicEventConsumer(Class<T> payloadClass, ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        this.eventType = objectMapper.getTypeFactory().constructParametricType(PushTopicEvent.class, new Class[]{payloadClass});
    }

    @Override
    public void accept(String json) {
        try {
            PushTopicEvent event = (PushTopicEvent)this.objectMapper.readValue(json, this.eventType);
            this.handleEvent(event);
        }
        catch (IOException e) {
            log.debug("Failed to parse message {}", (Object)json);
            this.handleException(e, json, this.eventType);
        }
    }

    public abstract void handleEvent(PushTopicEvent<T> var1);

    public void handleException(IOException exception, String json, JavaType eventType) {
    }
}

