/*
 * Decompiled with CFR 0.152.
 */
package io.cdsoft.sf.messaging.api.consumer;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.cdsoft.sf.messaging.api.consumer.JsonEventConsumer;
import io.cdsoft.sf.messaging.api.model.PlatformEvent;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JacksonPlatformEventConsumer<T>
implements JsonEventConsumer {
    private static final Logger log = LoggerFactory.getLogger(JacksonPlatformEventConsumer.class);
    private final JavaType eventType;
    private final ObjectMapper objectMapper;

    public JacksonPlatformEventConsumer(Class<T> payloadClass, ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        this.eventType = objectMapper.getTypeFactory().constructParametricType(PlatformEvent.class, new Class[]{payloadClass});
    }

    @Override
    public void accept(String json) {
        try {
            PlatformEvent event = (PlatformEvent)this.objectMapper.readValue(json, this.eventType);
            this.handleEvent(event);
        }
        catch (IOException e) {
            log.debug("Failed to parse message {}", (Object)json);
            this.handleException(e, json, this.eventType);
        }
    }

    public abstract void handleEvent(PlatformEvent<T> var1);

    public void handleException(IOException exception, String json, JavaType eventType) {
    }
}

