/*
 * Decompiled with CFR 0.152.
 */
package io.cdsoft.sf.messaging.api.client;

import io.cdsoft.sf.messaging.MessagingException;
import io.cdsoft.sf.messaging.api.config.ConnectionConfig;
import io.cdsoft.sf.messaging.api.subscription.Subscription;
import io.cdsoft.sf.messaging.internal.client.auth.ManagedAuthClient;
import io.cdsoft.sf.messaging.internal.client.cometd.ManagedCometdClient;
import io.cdsoft.sf.messaging.internal.client.http.ManagedHttpClient;

public class MessagingClient {
    private final ManagedAuthClient authClient;
    private final ManagedHttpClient httpClient = new ManagedHttpClient();
    private final ManagedCometdClient cometdClient;

    public MessagingClient(ConnectionConfig config) {
        this.authClient = new ManagedAuthClient(config, this.httpClient);
        this.cometdClient = new ManagedCometdClient(config, this.authClient, this.httpClient);
    }

    public void start() throws MessagingException {
        this.httpClient.doStart();
        this.authClient.doStart();
        this.cometdClient.doStart();
    }

    public void stop() throws MessagingException {
        this.cometdClient.doStop();
        this.authClient.doStop();
        this.httpClient.doStop();
    }

    public void addSubscription(Subscription subscription) {
        this.cometdClient.addSubscription(subscription);
    }

    public void removeSubscriptions(Subscription subscription) throws MessagingException {
        this.cometdClient.removeSubscription(subscription.getChannelName());
    }
}

