package io.burkard.cdk.services.elasticloadbalancingv2

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object NetworkLoadBalancerAttributes {

  def apply(
    loadBalancerArn: String,
    loadBalancerCanonicalHostedZoneId: Option[String] = None,
    loadBalancerDnsName: Option[String] = None,
    vpc: Option[software.amazon.awscdk.services.ec2.IVpc] = None
  ): software.amazon.awscdk.services.elasticloadbalancingv2.NetworkLoadBalancerAttributes =
    (new software.amazon.awscdk.services.elasticloadbalancingv2.NetworkLoadBalancerAttributes.Builder)
      .loadBalancerArn(loadBalancerArn)
      .loadBalancerCanonicalHostedZoneId(loadBalancerCanonicalHostedZoneId.orNull)
      .loadBalancerDnsName(loadBalancerDnsName.orNull)
      .vpc(vpc.orNull)
      .build()
}
