package io.burkard.cdk.services.elasticloadbalancingv2

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnListenerRule {

  def apply(
    internalResourceId: String,
    priority: Number,
    actions: List[_],
    listenerArn: String,
    conditions: List[_]
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.elasticloadbalancingv2.CfnListenerRule =
    software.amazon.awscdk.services.elasticloadbalancingv2.CfnListenerRule.Builder
      .create(stackCtx, internalResourceId)
      .priority(priority)
      .actions(actions.asJava)
      .listenerArn(listenerArn)
      .conditions(conditions.asJava)
      .build()
}
