package io.burkard.cdk.services.appmesh

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnMeshProps {

  def apply(
    spec: Option[software.amazon.awscdk.services.appmesh.CfnMesh.MeshSpecProperty] = None,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    meshName: Option[String] = None
  ): software.amazon.awscdk.services.appmesh.CfnMeshProps =
    (new software.amazon.awscdk.services.appmesh.CfnMeshProps.Builder)
      .spec(spec.orNull)
      .tags(tags.map(_.asJava).orNull)
      .meshName(meshName.orNull)
      .build()
}
